/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.internal;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.jdbc.internal.Column;
import kd.bos.flydb.jdbc.internal.Connection;
import kd.bos.flydb.jdbc.internal.Exceptions;
import kd.bos.flydb.jdbc.internal.ResultSetMetaData;
import kd.bos.flydb.jdbc.internal.RowReader;
import kd.bos.flydb.jdbc.internal.Statement;
import kd.bos.flydb.server.ResultInfo;
import kd.bos.flydb.server.facade.WorkerAPI;

public class ResultSet
implements java.sql.ResultSet {
    private final Statement statement;
    private final String resultId;
    private final RowReader rowReader;
    private final long total;
    private final List<Column> columns;
    private int fetchSize;
    private boolean closed;
    private List<Row> rows;
    private boolean hasMoreData = false;
    private int rowIndex = 0;
    private int offset = 0;

    public ResultSet(Statement statement, ResultInfo resultInfo, int fetchSize) {
        this.statement = statement;
        this.resultId = resultInfo.getResultId();
        this.fetchSize = fetchSize;
        this.total = resultInfo.getCount();
        this.rows = WorkerAPI.getRemote().fetch(this.resultId, fetchSize, this.offset);
        long count = resultInfo.getCount();
        if (count > (long)fetchSize) {
            this.hasMoreData = true;
            this.offset += fetchSize;
        }
        RowMeta rowMeta = resultInfo.getRowMeta();
        int fieldCount = rowMeta.getFieldCount();
        this.columns = new ArrayList<Column>(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = rowMeta.getFieldName(i);
            String fieldAlias = rowMeta.getFieldAlias(i);
            DataType dataType = rowMeta.getDataType(i);
            this.columns.add(new Column(fieldName, fieldAlias, dataType));
        }
        this.rowReader = new RowReader(this.columns);
    }

    private ResultSet(Column column, ArrayList<Object[]> data) {
        this.statement = null;
        this.resultId = null;
        this.fetchSize = 5000;
        this.total = data.size();
        this.columns = Collections.singletonList(column);
        this.rowReader = new RowReader(this.columns);
    }

    public static ResultSet createResultSet(Column column, ArrayList<Object[]> data) {
        return new ResultSet(column, data);
    }

    @Override
    public boolean next() throws SQLException {
        try {
            if (this.hasMoreData && this.rowIndex == this.fetchSize) {
                this.rows = WorkerAPI.getRemote().fetch(this.resultId, this.fetchSize, this.offset);
                this.rowIndex = 0;
                this.offset += this.rows.size();
                if ((long)this.offset == this.total) {
                    this.hasMoreData = false;
                }
                return this.next();
            }
            if (this.rowIndex < this.rows.size()) {
                this.rowReader.setRow(this.rows.get(this.rowIndex++));
                return true;
            }
            this.rowIndex = this.rows.size();
            this.rowReader.setRow(null);
            return false;
        }
        catch (Exception e) {
            throw Exceptions.wrap(e);
        }
    }

    public boolean isHasMoreData() {
        return this.hasMoreData;
    }

    @Override
    public void close() throws SQLException {
        try {
            if (!this.closed) {
                if (this.resultId != null) {
                    this.statement.getConnection().unwrap(Connection.class);
                    Connection.getExecutor().closeResult(this.resultId);
                }
                this.closed = true;
            }
        }
        catch (Exception e) {
            throw Exceptions.wrap(e);
        }
    }

    private void checkClose() throws SQLException {
        if (this.closed) {
            throw Exceptions.newSQLException(ErrorCode.ClientError_ResultSetHasBeenClosed, new Object[0]);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.rowReader.wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.rowReader.getStringValue(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.rowReader.getBooleanValue(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getByte");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.rowReader.getShortValue(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.rowReader.getIntValue(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.rowReader.getLongValue(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.rowReader.getFloatValue(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.rowReader.getDoubleValue(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.rowReader.getBigDecimalValue(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getBytes");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.rowReader.getDateValue(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.rowReader.getTimeValue(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.rowReader.getTimestampValue(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getAsciiStream");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getBinaryStream");
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.rowReader.getStringValue(columnLabel);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.rowReader.getBooleanValue(columnLabel);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getByte");
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.rowReader.getShortValue(columnLabel);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.rowReader.getIntValue(columnLabel);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.rowReader.getLongValue(columnLabel);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.rowReader.getFloatValue(columnLabel);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.rowReader.getDoubleValue(columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.rowReader.getBigDecimalValue(columnLabel);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getBytes");
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.rowReader.getDateValue(columnLabel);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.rowReader.getTimeValue(columnLabel);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.rowReader.getTimestampValue(columnLabel);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getAsciiStream(String columnLabel)");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getUnicodeStream(String columnLabel)");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getBinaryStream(String columnLabel)");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getWarnings()");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported clearWarnings()");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getCursorName()");
    }

    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        return new ResultSetMetaData(this.columns);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.rowReader.getValue(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.rowReader.getValue(columnLabel);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.rowReader.findColumn(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getCharacterStream(int columnIndex)");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getCharacterStream(String columnLabel)");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.rowReader.getBigDecimalValue(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.rowReader.getBigDecimalValue(columnLabel);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported isBeforeFirst()");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported isAfterLast()");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported isFirst()");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported isLast()");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported beforeFirst()");
    }

    @Override
    public void afterLast() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported afterLast()");
    }

    @Override
    public boolean first() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported first()");
    }

    @Override
    public boolean last() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported last()");
    }

    @Override
    public int getRow() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getRow()");
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported absolute(int row)");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported relative(int rows)");
    }

    @Override
    public boolean previous() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported previous()");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClose();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClose();
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClose();
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClose();
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getType()");
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getConcurrency()");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported rowUpdated()");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported rowInserted()");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported rowDeleted()");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateNull(int columnIndex)");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBoolean(int columnIndex, boolean x)");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateByte(int columnIndex, byte x)");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateShort(int columnIndex, short x)");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateInt(int columnIndex, int x)");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateLong(int columnIndex, long x)");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateFloat(int columnIndex, float x)");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateDouble(int columnIndex, double x)");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBigDecimal(int columnIndex, BigDecimal x)");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateString(int columnIndex, String x)");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBytes(int columnIndex, byte[] x)");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateDate(int columnIndex, Date x)");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateTime(int columnIndex, Time x)");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateTimestamp(int columnIndex, Timestamp x)");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateAsciiStream(int columnIndex, InputStream x, int length)");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBinaryStream(int columnIndex, InputStream x, int length)");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateCharacterStream(int columnIndex, Reader x, int length)");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateObject(int columnIndex, Object x, int scaleOrLength)");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateObject(int columnIndex, Object x)");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateNull(String columnLabel)");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBoolean(String columnLabel, boolean x)");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateByte(String columnLabel, byte x)");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateShort(String columnLabel, short x)");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateInt(String columnLabel, int x)");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateLong(String columnLabel, long x)");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateFloat(String columnLabel, float x)");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateDouble(String columnLabel, double x)");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBigDecimal(String columnLabel, BigDecimal x)");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateString(String columnLabel, String x)");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBytes(String columnLabel, byte[] x)");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateDate(String columnLabel, Date x)");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateTime(String columnLabel, Time x)");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateTimestamp(String columnLabel, Timestamp x)");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateAsciiStream(String columnLabel, InputStream x, int length)");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBinaryStream(String columnLabel, InputStream x, int length)");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateCharacterStream(String columnLabel, Reader reader, int length)");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateObject(String columnLabel, Object x, int scaleOrLength)");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateObject(String columnLabel, Object x)");
    }

    @Override
    public void insertRow() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported insertRow()");
    }

    @Override
    public void updateRow() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateRow()");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported deleteRow()");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported refreshRow()");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported cancelRowUpdates()");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported moveToInsertRow()");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported moveToCurrentRow()");
    }

    @Override
    public java.sql.Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(columnIndex);
        }
        throw new SQLException("Method ResultSet.getObject(int columnIndex, Map<String, Class<?>> map) not supported for non empty map");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getRef(int columnIndex)");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getBlob(int columnIndex)");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getClob(int columnIndex)");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getArray(int columnIndex)");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(columnLabel);
        }
        throw new SQLException("Method ResultSet.getObject(String columnLabel, Map<String, Class<?>> map) not supported");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getRef(String columnLabel)");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getBlob(String columnLabel)");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getClob(String columnLabel)");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getArray(String columnLabel)");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getDate(int columnIndex, Calendar cal)");
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getDate(String columnLabel, Calendar cal)");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getTime(int columnIndex, Calendar cal)");
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getTime(String columnLabel, Calendar cal)");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getTimestamp(int columnIndex, Calendar cal)");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getTimestamp(String columnLabel, Calendar cal)");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        Object s = this.rowReader.getValue(columnIndex);
        if (s == null) {
            return null;
        }
        try {
            return new URL(s.toString());
        }
        catch (MalformedURLException e) {
            throw new SQLException(String.format("Could not parse '%s' as URL", s), e);
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        Object s = this.rowReader.getValue(columnLabel);
        if (s == null) {
            return null;
        }
        try {
            return new URL(s.toString());
        }
        catch (MalformedURLException e) {
            throw new SQLException(String.format("Could not parse '%s' as URL", s), e);
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateRef(int columnIndex, Ref x)");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateRef(String columnLabel, Ref x)");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBlob(int columnIndex, Blob x)");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBlob(String columnLabel, Blob x)");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateClob(int columnIndex, Clob x)");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateClob(String columnLabel, Clob x)");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateArray(int columnIndex, Array x)");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateArray(String columnLabel, Array x)");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getRowId(int columnIndex)");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getRowId(String columnLabel)");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateRowId(int columnIndex, RowId x)");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateRowId(String columnLabel, RowId x)");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getHoldability()");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateNString(int columnIndex, String nString)");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateNString(String columnLabel, String nString)");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateNClob(int columnIndex, NClob nClob)");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateNClob(String columnLabel, NClob nClob)");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getNClob(int columnIndex)");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getNClob(String columnLabel)");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getSQLXML(int columnIndex)");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getSQLXML(String columnLabel)");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateSQLXML(int columnIndex, SQLXML xmlObject)");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateSQLXML(String columnLabel, SQLXML xmlObject)");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getNCharacterStream(int columnIndex)");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getNCharacterStream(String columnLabel)");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateNCharacterStream(int columnIndex, Reader x, long length)");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateNCharacterStream(String columnLabel, Reader reader, long length)");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateAsciiStream(int columnIndex, InputStream x, long length)");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBinaryStream(int columnIndex, InputStream x, long length)");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateCharacterStream(int columnIndex, Reader x, long length)");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateAsciiStream(String columnLabel, InputStream x, long length)");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBinaryStream(String columnLabel, InputStream x, long length)");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateCharacterStream(String columnLabel, Reader reader, long length)");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBlob(int columnIndex, InputStream inputStream, long length)");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBlob(String columnLabel, InputStream inputStream, long length)");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateClob(int columnIndex, Reader reader, long length)");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateClob(String columnLabel, Reader reader, long length)");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateNClob(int columnIndex, Reader reader, long length)");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateNClob(String columnLabel, Reader reader, long length)");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateNCharacterStream(int columnIndex, Reader x)");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateNCharacterStream(String columnLabel, Reader reader)");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateAsciiStream(int columnIndex, InputStream x)");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBinaryStream(int columnIndex, InputStream x)");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateCharacterStream(int columnIndex, Reader x)");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateAsciiStream(String columnLabel, InputStream x)");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBinaryStream(String columnLabel, InputStream x)");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateCharacterStream(String columnLabel, Reader reader)");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBlob(int columnIndex, InputStream inputStream)");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateBlob(String columnLabel, InputStream inputStream)");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateClob(int columnIndex, Reader reader)");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateClob(String columnLabel, Reader reader)");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateNClob(int columnIndex, Reader reader)");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateNClob(String columnLabel, Reader reader)");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getObject(int columnIndex, Class<T> type)");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getObject(String columnLabel, Class<T> type)");
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength)");
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength)");
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateObject(int columnIndex, Object x, SQLType targetSqlType)");
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported updateObject(String columnLabel, Object x, SQLType targetSqlType)");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw Exceptions.newSQLException(ErrorCode.ClientError_UnwrapFail, iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

