/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.internal;

import java.sql.SQLException;
import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.flydb.jdbc.internal.Column;

public class ResultSetMetaData
implements java.sql.ResultSetMetaData {
    private final List<Column> columns;

    public ResultSetMetaData(List<Column> columns) {
        this.columns = columns;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columns.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        throw new SQLException("Unsupported method isNullable.");
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        throw new SQLException("Unsupported method getColumnDisplaySize.");
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumn(column).getAlias();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumn(column).getName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getColumn(column).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumn(column).getScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return DataType.toSqlType((DataType)this.getColumn(column).getDataType());
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumn(column).getDataType().getName();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getColumn(column).getDataType().getJavaType().getName();
    }

    private Column getColumn(int column) throws SQLException {
        if (column >= 1 && column <= this.getColumnCount()) {
            return this.columns.get(column - 1);
        }
        throw new SQLException(String.format("Wrong column index %s", column));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw new SQLException("The receiver is not a wrapper for " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

