/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.internal;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.Row;
import kd.bos.flydb.jdbc.internal.Column;

public final class RowReader {
    private final int columnCount;
    private Row row;
    private int columnIdx;
    private final Map<String, Integer> aliasMap;

    public RowReader(List<Column> columns) {
        this.columnCount = columns.size();
        this.aliasMap = new HashMap<String, Integer>(this.columnCount);
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            this.aliasMap.put(column.getAlias(), i + 1);
        }
    }

    public void setRow(Row row) {
        this.row = row;
    }

    private void checkIndexAndSetPos(int index) throws SQLException {
        if (index < 1 || index > this.columnCount) {
            throw new SQLException(String.format("Wrong index position. Is %s but must be in 1-%s range", index, this.columnCount));
        }
        if (this.row == null) {
            throw new SQLDataException("wrong row position", "22023");
        }
        this.setPosition(index - 1);
    }

    private void setPosition(int newIndex) {
        this.columnIdx = newIndex;
    }

    public boolean wasNull() {
        return Objects.isNull(this.row.get(this.columnIdx));
    }

    public String getStringValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        return this.row.getString(this.columnIdx);
    }

    public boolean getBooleanValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        return this.row.getBoolean(this.columnIdx);
    }

    public short getShortValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        Object value = this.row.get(this.columnIdx);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        return Short.parseShort(String.valueOf(value));
    }

    public int getIntValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        return this.row.getInteger(this.columnIdx);
    }

    public long getLongValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        return this.row.getLong(this.columnIdx);
    }

    public float getFloatValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        return this.row.getBigDecimal(this.columnIdx) == null ? 0.0f : this.row.getBigDecimal(this.columnIdx).floatValue();
    }

    public double getDoubleValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        return this.row.getBigDecimal(this.columnIdx) == null ? 0.0 : this.row.getBigDecimal(this.columnIdx).doubleValue();
    }

    public BigDecimal getBigDecimalValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        return this.row.getBigDecimal(this.columnIdx);
    }

    public Date getDateValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        return this.row.getDate(this.columnIdx) == null ? null : new Date(this.row.getDate(this.columnIdx).getTime());
    }

    public Time getTimeValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        return this.row.getTimestamp(this.columnIdx) == null ? null : new Time(this.row.getTimestamp(this.columnIdx).getTime());
    }

    public Timestamp getTimestampValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        return this.row.getTimestamp(this.columnIdx);
    }

    public Object getValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        return this.row.get(this.columnIdx);
    }

    private void checkColumnLabel(String columnLabel) throws SQLException {
        if (!this.aliasMap.containsKey(columnLabel)) {
            throw new SQLException("unknown columnLable:" + columnLabel);
        }
    }

    public String getStringValue(String columnLabel) throws SQLException {
        this.checkColumnLabel(columnLabel);
        return this.row.getString(columnLabel);
    }

    public boolean getBooleanValue(String columnLabel) throws SQLException {
        this.checkColumnLabel(columnLabel);
        return this.row.getBoolean(columnLabel);
    }

    public short getShortValue(String columnLabel) throws SQLException {
        this.checkColumnLabel(columnLabel);
        Object value = this.row.get(columnLabel);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        return Short.parseShort(String.valueOf(value));
    }

    public int getIntValue(String columnLabel) throws SQLException {
        this.checkColumnLabel(columnLabel);
        return this.row.getInteger(columnLabel);
    }

    public long getLongValue(String columnLabel) throws SQLException {
        this.checkColumnLabel(columnLabel);
        return this.row.getLong(columnLabel);
    }

    public float getFloatValue(String columnLabel) throws SQLException {
        this.checkColumnLabel(columnLabel);
        return this.row.getBigDecimal(columnLabel) == null ? 0.0f : this.row.getBigDecimal(columnLabel).floatValue();
    }

    public double getDoubleValue(String columnLabel) throws SQLException {
        this.checkColumnLabel(columnLabel);
        return this.row.getBigDecimal(columnLabel) == null ? 0.0 : this.row.getBigDecimal(columnLabel).doubleValue();
    }

    public BigDecimal getBigDecimalValue(String columnLabel) throws SQLException {
        this.checkColumnLabel(columnLabel);
        return this.row.getBigDecimal(columnLabel);
    }

    public Date getDateValue(String columnLabel) throws SQLException {
        this.checkColumnLabel(columnLabel);
        return this.row.getDate(columnLabel) == null ? null : new Date(this.row.getDate(columnLabel).getTime());
    }

    public Time getTimeValue(String columnLabel) throws SQLException {
        this.checkColumnLabel(columnLabel);
        return this.row.getTimestamp(columnLabel) == null ? null : new Time(this.row.getTimestamp(columnLabel).getTime());
    }

    public Timestamp getTimestampValue(String columnLabel) throws SQLException {
        this.checkColumnLabel(columnLabel);
        return this.row.getTimestamp(columnLabel);
    }

    public Object getValue(String columnLabel) throws SQLException {
        this.checkColumnLabel(columnLabel);
        return this.row.get(columnLabel);
    }

    public int findColumn(String columnLabel) {
        return this.aliasMap.get(columnLabel);
    }
}

