/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.internal;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.jdbc.internal.Connection;
import kd.bos.flydb.jdbc.internal.Exceptions;
import kd.bos.flydb.jdbc.internal.ResultSet;
import kd.bos.flydb.server.QueryContext;
import kd.bos.flydb.server.ResultInfo;

public class Statement
implements java.sql.Statement {
    private final Connection connection;
    private int fetchSize;
    private String statementId;
    private int queryTimeout = -1;
    private List<ResultSet> results = new ArrayList<ResultSet>();
    protected ResultSet currResult;
    private boolean closed;

    public Statement(Connection connection, int fetchSize) {
        this.connection = connection;
        this.fetchSize = fetchSize;
    }

    @Override
    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        try {
            this.connection.getLock().lock();
            this.executeInternal(sql);
            ResultSet resultSet = this.currResult = this.results.remove(0);
            return resultSet;
        }
        finally {
            this.connection.getLock().unlock();
        }
    }

    private void executeInternal(String sql) throws SQLException {
        try {
            Statement statement = this;
            this.statementId = statement.connection.getExecutor().prepare(this.connection.getConnectionId(), sql);
            Statement statement2 = this;
            ResultInfo resultInfo = statement2.connection.getExecutor().executeQuery(new QueryContext(this.queryTimeout, this.fetchSize), this.statementId, sql, new Object[0]);
            ResultSet resultSet = new ResultSet(this, resultInfo, this.fetchSize);
            this.results.add(resultSet);
        }
        catch (Exception e) {
            throw Exceptions.wrap(e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported executeUpdate(String sql)");
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            try {
                if (this.currResult != null) {
                    this.currResult.close();
                }
                if (this.results != null && !this.results.isEmpty()) {
                    for (ResultSet result : this.results) {
                        result.close();
                    }
                }
                if (this.statementId != null) {
                    Statement statement = this;
                    statement.connection.getExecutor().closeStatement(this.statementId);
                }
                this.closed = true;
            }
            catch (Exception e) {
                throw Exceptions.wrap(e);
            }
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getMaxFieldSize().");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported setMaxFieldSize(int max).");
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getMaxRows().");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported setMaxRows(int max).");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported setEscapeProcessing(boolean enable).");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported cancel().");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getWarnings().");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported clearWarnings().");
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported setCursorName(String name).");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.executeQuery(sql);
        return this.currResult instanceof ResultSet;
    }

    @Override
    public java.sql.ResultSet getResultSet() throws SQLException {
        this.checkNotClosed();
        if (this.currResult instanceof ResultSet) {
            return this.currResult;
        }
        return null;
    }

    protected void checkNotClosed() throws SQLException {
        if (this.closed) {
            throw Exceptions.newSQLException(ErrorCode.ClientError_StatementHasBeenClosed, new Object[0]);
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getUpdateCount().");
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported setFetchDirection(int direction).");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getFetchDirection().");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getResultSetConcurrency().");
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getResultSetType().");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported addBatch(String sql).");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported clearBatch().");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported executeBatch()");
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkNotClosed();
        if (this.currResult instanceof ResultSet) {
            ResultSet result = this.currResult;
            if (current == 1) {
                result.close();
            }
            if (result.isHasMoreData()) {
                return true;
            }
        }
        this.currResult = null;
        return false;
    }

    @Override
    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getGeneratedKeys().");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported executeUpdate(String sql, int autoGeneratedKeys).");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported executeUpdate(String sql, int[] columnIndexes).");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported executeUpdate(String sql, String[] columnNames).");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported execute(String sql, int autoGeneratedKeys).");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported execute(String sql, int[] columnIndexes).");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported execute(String sql, String[] columnNames).");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported getResultSetHoldability().");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported setPoolable(boolean poolable).");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported isPoolable().");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported closeOnCompletion().");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw Exceptions.newUnsupportedException("Unsupported isCloseOnCompletion().");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw Exceptions.newSQLException(ErrorCode.ClientError_UnwrapFail, iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

