/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core;

import java.io.Serializable;
import java.util.Properties;
import kd.bos.flydb.core.Contexts;
import kd.bos.flydb.core.FlyPrepare;
import kd.bos.flydb.core.FlyPrepareImpl;
import kd.bos.flydb.core.rex.RexLiteral;
import kd.bos.flydb.core.sql.type.DataType;

public class Context
implements AutoCloseable,
Serializable {
    private final String sessionId;
    private final String currentSchema;
    private final Long currentUserId;
    private final Properties config = new Properties();
    private Context parent;
    private Param[] params;
    private static final ThreadLocal<FlyPrepare> prepareThreadLocal = new ThreadLocal();

    public Context(String sessionId, String currentSchema, Long currentUserId) {
        this.sessionId = sessionId;
        this.currentSchema = currentSchema;
        this.currentUserId = currentUserId;
    }

    public Context(String sessionId, String currentSchema, Long currentUserId, Context parent) {
        this.parent = parent;
        this.sessionId = sessionId;
        this.currentSchema = currentSchema;
        this.currentUserId = currentUserId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getCurrentSchema() {
        return this.currentSchema;
    }

    public Long getCurrentUserId() {
        return this.currentUserId;
    }

    public String getCurrentDatabase() {
        return "cosmic_db";
    }

    @Override
    public void close() {
        Contexts.clear(this);
    }

    protected Context getParent() {
        return this.parent;
    }

    public Param getParam(int i) {
        return this.params[i];
    }

    public void bindParam(Param[] params) {
        this.params = params;
    }

    public Properties getConfig() {
        return this.config;
    }

    public void putConfig(String key, String value) {
        this.config.put(key, value);
    }

    public String getConfig(String key) {
        return this.config.getProperty(key);
    }

    public void setParent(Context parent) {
        this.parent = parent;
    }

    public FlyPrepare prepare() {
        FlyPrepare prepare = prepareThreadLocal.get();
        if (prepare == null) {
            prepare = new FlyPrepareImpl();
            prepareThreadLocal.set(prepare);
        }
        return prepare;
    }

    public static class Param
    implements Serializable {
        public final Object value;
        public final DataType type;

        public Param(Object value, DataType type) {
            this.value = value;
            this.type = type;
        }

        public RexLiteral toLiteral() {
            return new RexLiteral(this.type, this.value);
        }
    }
}

