/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core;

import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.Context;

public class Contexts {
    private static final ThreadLocal<Context> THREAD_LOCAL = new ThreadLocal();

    public static Context get() {
        return THREAD_LOCAL.get();
    }

    public static Context create(String schema, Long userId) {
        Context context = new Context("", schema, userId, Contexts.get());
        THREAD_LOCAL.set(context);
        return context;
    }

    public static Context create(String sessionId, String schema, Long userId) {
        Context context = new Context(sessionId, schema, userId, Contexts.get());
        THREAD_LOCAL.set(context);
        return context;
    }

    public static Context set(Context context) {
        context.setParent(Contexts.get());
        THREAD_LOCAL.set(context);
        return context;
    }

    public static void clear(Context c1) {
        Context context = THREAD_LOCAL.get();
        if (c1 != context) {
            throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_ContextClose, (Object[])new Object[0]);
        }
        if (context != null) {
            THREAD_LOCAL.remove();
            if (context.getParent() != null) {
                THREAD_LOCAL.set(context.getParent());
            }
        }
    }
}

