/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Properties;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.Context;
import kd.bos.flydb.core.Contexts;
import kd.bos.flydb.core.FlyPrepare;
import kd.bos.flydb.core.interpreter.Executor;
import kd.bos.flydb.core.interpreter.bind.BindableNode;
import kd.bos.flydb.core.rel.RelNode;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.validate.SqlValidateConfig;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.impl.SqlValidatorFactory;

public final class Core {
    public static final String TRACE_TYPE = "flydb";

    private Core() {
    }

    public static Executor.Result execute(String sessionId, String currentSchema, Long currentUserId, Properties config, String sql, Object[] params) {
        Context context = new Context(sessionId, currentSchema, currentUserId);
        for (String name : config.stringPropertyNames()) {
            context.putConfig(name, config.getProperty(name));
        }
        context.bindParam(Core.toBindParam(params));
        try (Context run = Contexts.set(context);){
            Executor executor;
            SqlValidator validator = SqlValidatorFactory.newValidator(new SqlValidateConfig());
            FlyPrepare prepare = run.prepare();
            SqlNode sqlNode = prepare.parse(sql);
            if (sqlNode.getKind() == SqlKind.USE) {
                executor = prepare.compile(run, validator.validate(sqlNode));
            } else if (sqlNode.getKind() == SqlKind.SET_SESSION_VARIABLE) {
                executor = prepare.execute(run, validator.validate(sqlNode));
            } else {
                RelNode relNode = prepare.translate(sqlNode, validator);
                BindableNode bindableNode = prepare.optimize(relNode);
                bindableNode = prepare.bind(bindableNode, run);
                executor = prepare.compile(bindableNode);
            }
            Executor.Result result = executor.executeQuery();
            return result;
        }
    }

    public static Context.Param[] toBindParam(Object[] params) {
        if (params == null) {
            return new Context.Param[0];
        }
        DataTypeFactory typeFactory = DataTypeFactory.instance;
        Context.Param[] result = new Context.Param[params.length];
        for (int i = 0; i < params.length; ++i) {
            Object value = params[i];
            if (value == null) {
                result[i] = new Context.Param(null, typeFactory.buildNullType());
                continue;
            }
            if (value instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)value;
                result[i] = new Context.Param(value, typeFactory.buildDecimal(bigDecimal.precision(), bigDecimal.scale()));
                continue;
            }
            if (value instanceof Integer) {
                result[i] = new Context.Param(value, typeFactory.buildInt());
                continue;
            }
            if (value instanceof Long) {
                result[i] = new Context.Param(value, typeFactory.buildLong());
                continue;
            }
            if (value instanceof String) {
                result[i] = new Context.Param(value, typeFactory.buildString());
                continue;
            }
            if (value instanceof Date) {
                result[i] = new Context.Param(value, typeFactory.buildDate());
                continue;
            }
            if (value instanceof Time) {
                result[i] = new Context.Param(value, typeFactory.buildTime());
                continue;
            }
            if (value instanceof Timestamp) {
                result[i] = new Context.Param(value, typeFactory.buildDatetime());
                continue;
            }
            if (value instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)value;
                result[i] = new Context.Param(new Timestamp(date.getTime()), typeFactory.buildDatetime());
                continue;
            }
            if (value instanceof LocalTime) {
                LocalTime localTime = (LocalTime)value;
                result[i] = new Context.Param(Time.valueOf(localTime), typeFactory.buildTime());
                continue;
            }
            if (value instanceof LocalDate) {
                LocalDate localDate = (LocalDate)value;
                result[i] = new Context.Param(Date.valueOf(localDate), typeFactory.buildDate());
                continue;
            }
            if (value instanceof LocalDateTime) {
                result[i] = new Context.Param(Timestamp.valueOf((LocalDateTime)value), typeFactory.buildDatetime());
                continue;
            }
            throw Exceptions.of((ErrorCode)ErrorCode.UnknownParamType, (Object[])new Object[]{value.getClass().getName()});
        }
        return result;
    }
}

