/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core;

import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.Context;
import kd.bos.flydb.core.ExecuteParams;
import kd.bos.flydb.core.ExecutorManager;
import kd.bos.flydb.core.ExecutorSupplier;
import kd.bos.flydb.core.FlyPrepare;
import kd.bos.flydb.core.interpreter.BindNodeCompiler;
import kd.bos.flydb.core.interpreter.Executor;
import kd.bos.flydb.core.interpreter.SetVariableExecutor;
import kd.bos.flydb.core.interpreter.bind.BindHelp;
import kd.bos.flydb.core.interpreter.bind.BindableNode;
import kd.bos.flydb.core.optimize.OptimizeHelp;
import kd.bos.flydb.core.rel.RelNode;
import kd.bos.flydb.core.sql.parser.Parser;
import kd.bos.flydb.core.sql.parser.ParserConfig;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlSetVariable;
import kd.bos.flydb.core.sql.tree.SqlUse;
import kd.bos.flydb.core.sql.validate.SqlValidateConfig;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class FlyPrepareImpl
implements FlyPrepare {
    private static final String defaultCompilerClassName = "kd.bos.flydb.core.interpreter.algox.AlgoXBindNodeCompiler";
    private final ParserConfig parserConfig;
    private final SqlValidateConfig validateConfig;
    private final String compilerClassName;

    public FlyPrepareImpl() {
        this(new ParserConfig(), new SqlValidateConfig());
    }

    public FlyPrepareImpl(ParserConfig parserConfig, SqlValidateConfig validateConfig) {
        this(parserConfig, validateConfig, defaultCompilerClassName);
    }

    public FlyPrepareImpl(ParserConfig parserConfig, SqlValidateConfig validateConfig, String compilerClassName) {
        this.parserConfig = parserConfig;
        this.validateConfig = validateConfig;
        this.compilerClassName = compilerClassName;
    }

    @Override
    public SqlNode parse(String sql) {
        try (TraceSpan span = Tracer.create((String)"flydb", (String)"prepare");){
            Parser parser = new Parser(this.parserConfig);
            SqlNode sqlNode = parser.parse(sql);
            return sqlNode;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public RelNode translate(SqlNode sqlNode, SqlValidator validator) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public BindableNode optimize(RelNode relNode) {
        try (TraceSpan span = Tracer.create((String)"flydb", (String)"optimize");){
            BindableNode bindableNode = OptimizeHelp.optimize(relNode);
            return bindableNode;
        }
    }

    @Override
    public BindableNode bind(BindableNode bindableNode, Context context) {
        try (TraceSpan span = Tracer.create((String)"flydb", (String)"bind");){
            BindableNode bindableNode2 = BindHelp.bind(bindableNode, context);
            return bindableNode2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Executor compile(BindableNode bindableNode) {
        try (TraceSpan span = Tracer.create((String)"flydb", (String)"compile");){
            bindableNode = OptimizeHelp.optimizeConstExpression(bindableNode);
            BindNodeCompiler compiler = (BindNodeCompiler)Class.forName(this.compilerClassName).newInstance();
            Executor executor = compiler.compile(bindableNode);
            return executor;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw Exceptions.of((ErrorCode)ErrorCode.ServerError_CompilerCreateFail, (Object[])new Object[]{e.getMessage()});
        }
    }

    @Override
    public Executor compile(Context context, SqlNode sqlNode) {
        Throwable throwable = null;
        try (TraceSpan span = Tracer.create((String)"flydb", (String)"compile");){
            ExecutorSupplier supplier = ExecutorManager.getSupplier(sqlNode.getKind());
            if (supplier != null) {
                ExecuteParams params = null;
                if (sqlNode.getKind() == SqlKind.USE) {
                    String targetSchema;
                    String targetDatabase = context.getCurrentDatabase();
                    List<String> target = ((SqlUse)sqlNode).getNames();
                    if (target.size() > 1) {
                        targetDatabase = target.get(0);
                        targetSchema = target.get(1);
                    } else {
                        targetSchema = target.get(0);
                    }
                    params = new ExecuteParams(context.getSessionId(), targetDatabase, targetSchema);
                }
                Executor executor = supplier.get(params);
                return executor;
            }
            try {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedSqlKind, (Object[])new Object[]{sqlNode.getKind()});
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public Executor execute(Context context, SqlNode sqlNode) {
        Throwable throwable = null;
        try (TraceSpan span = Tracer.create((String)"flydb", (String)"execute");){
            if (sqlNode.getKind() == SqlKind.SET_SESSION_VARIABLE) {
                SetVariableExecutor setVariableExecutor = new SetVariableExecutor(sqlNode.cast(SqlSetVariable.class));
                return setVariableExecutor;
            }
            try {
                throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

