/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.Context;
import kd.bos.flydb.core.FlyPrepare;
import kd.bos.flydb.core.interpreter.Executor;
import kd.bos.flydb.core.interpreter.algox.DataSetOutputManager;
import kd.bos.flydb.core.interpreter.algox.DataSetOutputManagers;
import kd.bos.flydb.core.interpreter.algox.DataSetReader;
import kd.bos.flydb.core.interpreter.bind.BindableNode;
import kd.bos.flydb.core.interpreter.scalar.Abs;
import kd.bos.flydb.core.interpreter.scalar.Add;
import kd.bos.flydb.core.interpreter.scalar.AddMonths;
import kd.bos.flydb.core.interpreter.scalar.AddWeeks;
import kd.bos.flydb.core.interpreter.scalar.AddYears;
import kd.bos.flydb.core.interpreter.scalar.And;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.CaseWhen;
import kd.bos.flydb.core.interpreter.scalar.Cast;
import kd.bos.flydb.core.interpreter.scalar.Ceiling;
import kd.bos.flydb.core.interpreter.scalar.Concat;
import kd.bos.flydb.core.interpreter.scalar.CurrentSchema;
import kd.bos.flydb.core.interpreter.scalar.CurrentUser;
import kd.bos.flydb.core.interpreter.scalar.DataSetLiteral;
import kd.bos.flydb.core.interpreter.scalar.DateAdd;
import kd.bos.flydb.core.interpreter.scalar.DateSub;
import kd.bos.flydb.core.interpreter.scalar.Divide;
import kd.bos.flydb.core.interpreter.scalar.Equals;
import kd.bos.flydb.core.interpreter.scalar.Floor;
import kd.bos.flydb.core.interpreter.scalar.GT;
import kd.bos.flydb.core.interpreter.scalar.GTE;
import kd.bos.flydb.core.interpreter.scalar.InListOrNot;
import kd.bos.flydb.core.interpreter.scalar.InputRef;
import kd.bos.flydb.core.interpreter.scalar.IsNullOrNot;
import kd.bos.flydb.core.interpreter.scalar.LT;
import kd.bos.flydb.core.interpreter.scalar.LTE;
import kd.bos.flydb.core.interpreter.scalar.Length;
import kd.bos.flydb.core.interpreter.scalar.LikeOrNot;
import kd.bos.flydb.core.interpreter.scalar.Literal;
import kd.bos.flydb.core.interpreter.scalar.Lower;
import kd.bos.flydb.core.interpreter.scalar.Mod;
import kd.bos.flydb.core.interpreter.scalar.Multiply;
import kd.bos.flydb.core.interpreter.scalar.Not;
import kd.bos.flydb.core.interpreter.scalar.NotEquals;
import kd.bos.flydb.core.interpreter.scalar.Null;
import kd.bos.flydb.core.interpreter.scalar.OR;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.SubMonths;
import kd.bos.flydb.core.interpreter.scalar.SubString;
import kd.bos.flydb.core.interpreter.scalar.SubWeeks;
import kd.bos.flydb.core.interpreter.scalar.SubYears;
import kd.bos.flydb.core.interpreter.scalar.Subtract;
import kd.bos.flydb.core.interpreter.scalar.ToChar;
import kd.bos.flydb.core.interpreter.scalar.ToDate;
import kd.bos.flydb.core.interpreter.scalar.ToDatetime;
import kd.bos.flydb.core.interpreter.scalar.ToDecimal;
import kd.bos.flydb.core.interpreter.scalar.ToTime;
import kd.bos.flydb.core.interpreter.scalar.Unary;
import kd.bos.flydb.core.interpreter.scalar.Upper;
import kd.bos.flydb.core.interpreter.scalar.Version;
import kd.bos.flydb.core.interpreter.scalar.XOR;
import kd.bos.flydb.core.rel.RelNode;
import kd.bos.flydb.core.rex.RexCall;
import kd.bos.flydb.core.rex.RexDynamicParam;
import kd.bos.flydb.core.rex.RexInputRef;
import kd.bos.flydb.core.rex.RexLiteral;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.rex.RexNodeList;
import kd.bos.flydb.core.rex.RexSubQuery;
import kd.bos.flydb.core.sql.tree.SqlCaseWhenType;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.type.DataType;

public class ScalarEvaluationCompiler {
    private final Context context;
    private final List<String> subqueryDataSetIdList = new ArrayList<String>();
    private static Map<SqlKind, ScalarProduce> scalarProduceMap = new IdentityHashMap<SqlKind, ScalarProduce>();

    public ScalarEvaluationCompiler(Context context) {
        this.context = context;
    }

    public List<String> getSubQueryResults() {
        return this.subqueryDataSetIdList;
    }

    public ScalarEvaluation compile(RexNode rexNode) {
        return this.compile0(rexNode);
    }

    private ScalarEvaluation compile0(RexNode rexNode) {
        if (rexNode instanceof RexLiteral) {
            if (((RexLiteral)rexNode).isNullExpression()) {
                return new Null(rexNode.getType());
            }
            return this.rexLiteral(rexNode.cast(RexLiteral.class));
        }
        if (rexNode instanceof RexInputRef) {
            return this.rexInputRef(rexNode.cast(RexInputRef.class));
        }
        if (rexNode instanceof RexCall) {
            RexCall call = rexNode.cast(RexCall.class);
            ScalarProduce scalarProduce = scalarProduceMap.get((Object)rexNode.getKind());
            if (scalarProduce == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompiler, (Object[])new Object[]{rexNode});
            }
            return scalarProduce.produce(call, this);
        }
        if (rexNode instanceof RexSubQuery) {
            BaseScalarEvaluation evaluation;
            boolean releaseResultSet;
            FlyPrepare prepare = this.context.prepare();
            RelNode sq = ((RexSubQuery)rexNode).getQuery();
            Executor executor = prepare.compile((BindableNode)sq);
            Executor.QueryResult result = (Executor.QueryResult)executor.executeQuery();
            DataSetOutputManager manager = DataSetOutputManagers.get();
            try (DataSetReader dataSetReader = manager.createReader(result.cursorId);){
                long count = dataSetReader.getCount();
                if (count == 0L) {
                    releaseResultSet = true;
                    evaluation = new Null(rexNode.getType());
                } else if (count == 1L) {
                    releaseResultSet = true;
                    List<Row> data = dataSetReader.read(1, 0);
                    evaluation = new Literal(data.get(0).get(0), rexNode.getType());
                } else {
                    releaseResultSet = false;
                    evaluation = new DataSetLiteral(result.cursorId, rexNode.getType());
                }
            }
            if (releaseResultSet) {
                manager.deleteDataSet(result.cursorId);
            } else {
                this.subqueryDataSetIdList.add(result.cursorId);
            }
            return evaluation;
        }
        if (rexNode instanceof RexDynamicParam) {
            throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompiler, (Object[])new Object[]{"DynamicParam"});
        }
        if (rexNode == null) {
            return new Null(null);
        }
        throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompiler, (Object[])new Object[]{rexNode.getDigest()});
    }

    private ScalarEvaluation rexLiteral(RexLiteral literal) {
        return new Literal(literal.getValue(), literal.getType());
    }

    private ScalarEvaluation rexInputRef(RexInputRef inputRef) {
        return new InputRef(inputRef.getIndex(), inputRef.getType());
    }

    static {
        AddCompile addCompile = new AddCompile();
        SubtractCompile subtractCompile = new SubtractCompile();
        MultiplyCompile multiplyCompile = new MultiplyCompile();
        ModCompile modCompile = new ModCompile();
        DivideCompile divideCompile = new DivideCompile();
        UnaryCompile unaryCompile = new UnaryCompile();
        AndCompile andCompile = new AndCompile();
        OrCompile orCompile = new OrCompile();
        NotCompile notCompile = new NotCompile();
        EqualsCompile equalsCompile = new EqualsCompile();
        NotEqualsCompile notEqualsCompile = new NotEqualsCompile();
        LessThanCompile lessThanCompile = new LessThanCompile();
        LessThanOrEqualsCompile lessThanOrEqualsCompile = new LessThanOrEqualsCompile();
        GreaterThanCompile greaterThan = new GreaterThanCompile();
        GreaterThanOrEqualsCompile greaterThanOrEqualsCompile = new GreaterThanOrEqualsCompile();
        IsNullCompile isNullCompile = new IsNullCompile();
        IsNotNullCompile isNotNullCompile = new IsNotNullCompile();
        InCompile inCompile = new InCompile();
        NotInCompile notInCompile = new NotInCompile();
        LikeCompile likeCompile = new LikeCompile();
        NotLikeCompile notLikeCompile = new NotLikeCompile();
        CaseWhenCompile caseWhenCompile = new CaseWhenCompile();
        FuncAndCompile funcAndCompile = new FuncAndCompile();
        FuncOrCompile funcOrCompile = new FuncOrCompile();
        FuncXorCompile funcXorCompile = new FuncXorCompile();
        FuncAbsCompile funcAbsCompile = new FuncAbsCompile();
        FuncModCompile funcModCompile = new FuncModCompile();
        FuncCeilCompile funcCeilCompile = new FuncCeilCompile();
        FuncFloorCompile funcFloorCompile = new FuncFloorCompile();
        FuncConcatCompile funcConcatCompile = new FuncConcatCompile();
        FuncLengthCompile funcLengthCompile = new FuncLengthCompile();
        FuncLowerCompile funcLowerCompile = new FuncLowerCompile();
        FuncUpperCompile funcUpperCompile = new FuncUpperCompile();
        FuncSubStringCompile funcSubStringCompile = new FuncSubStringCompile();
        FuncCastCompile funcCastCompile = new FuncCastCompile();
        FuncToCharCompile funcToCharCompile = new FuncToCharCompile();
        FuncToDateCompile funcToDateCompile = new FuncToDateCompile();
        FuncToTimeCompile funcToTimeCompile = new FuncToTimeCompile();
        FuncToDateTimeCompile funcToDateTimeCompile = new FuncToDateTimeCompile();
        FuncToDecimalCompile funcToDecimalCompile = new FuncToDecimalCompile();
        FuncVersionCompile funcVersionCompile = new FuncVersionCompile();
        FuncCurrentUserCompile funcCurrentUserCompile = new FuncCurrentUserCompile();
        FuncCurrentSchemaCompile funcCurrentSchemaCompile = new FuncCurrentSchemaCompile();
        FuncDateAddCompile funcDateAddCompile = new FuncDateAddCompile();
        FuncDateSubCompile funcDateSubCompile = new FuncDateSubCompile();
        FuncAddWeeksCompile funcAddWeeksCompile = new FuncAddWeeksCompile();
        FuncSubWeeksCompile funcSubWeeksCompile = new FuncSubWeeksCompile();
        FuncAddMonthsCompile funcAddMonthsCompile = new FuncAddMonthsCompile();
        FuncSubMonthsCompile funcSubMonthsCompile = new FuncSubMonthsCompile();
        FuncAddYearsCompile funcAddYearsCompile = new FuncAddYearsCompile();
        FuncSubYearsCompile funcSubYearsCompile = new FuncSubYearsCompile();
        scalarProduceMap.put(SqlKind.PLUS, addCompile);
        scalarProduceMap.put(SqlKind.MINUS, subtractCompile);
        scalarProduceMap.put(SqlKind.TIMES, multiplyCompile);
        scalarProduceMap.put(SqlKind.MOD, modCompile);
        scalarProduceMap.put(SqlKind.DIVIDE, divideCompile);
        scalarProduceMap.put(SqlKind.UNARY, unaryCompile);
        scalarProduceMap.put(SqlKind.AND, andCompile);
        scalarProduceMap.put(SqlKind.OR, orCompile);
        scalarProduceMap.put(SqlKind.NOT, notCompile);
        scalarProduceMap.put(SqlKind.EQUALS, equalsCompile);
        scalarProduceMap.put(SqlKind.NOT_EQUALS, notEqualsCompile);
        scalarProduceMap.put(SqlKind.LESS_THAN, lessThanCompile);
        scalarProduceMap.put(SqlKind.LESS_THAN_OR_EQUALS, lessThanOrEqualsCompile);
        scalarProduceMap.put(SqlKind.GREATER_THAN, greaterThan);
        scalarProduceMap.put(SqlKind.GREATER_THAN_OR_EQUALS, greaterThanOrEqualsCompile);
        scalarProduceMap.put(SqlKind.IS_NULL, isNullCompile);
        scalarProduceMap.put(SqlKind.IS_NOT_NULL, isNotNullCompile);
        scalarProduceMap.put(SqlKind.IN, inCompile);
        scalarProduceMap.put(SqlKind.NOT_IN, notInCompile);
        scalarProduceMap.put(SqlKind.LIKE, likeCompile);
        scalarProduceMap.put(SqlKind.NOT_LIKE, notLikeCompile);
        scalarProduceMap.put(SqlKind.CASE, caseWhenCompile);
        scalarProduceMap.put(SqlKind.FUNC_AND, funcAndCompile);
        scalarProduceMap.put(SqlKind.FUNC_OR, funcOrCompile);
        scalarProduceMap.put(SqlKind.FUNC_XOR, funcXorCompile);
        scalarProduceMap.put(SqlKind.FUNC_ABS, funcAbsCompile);
        scalarProduceMap.put(SqlKind.FUNC_MOD, funcModCompile);
        scalarProduceMap.put(SqlKind.FUNC_CEIL, funcCeilCompile);
        scalarProduceMap.put(SqlKind.FUNC_FLOOR, funcFloorCompile);
        scalarProduceMap.put(SqlKind.FUNC_CONCAT, funcConcatCompile);
        scalarProduceMap.put(SqlKind.FUNC_LENGTH, funcLengthCompile);
        scalarProduceMap.put(SqlKind.FUNC_LOWER, funcLowerCompile);
        scalarProduceMap.put(SqlKind.FUNC_UPPER, funcUpperCompile);
        scalarProduceMap.put(SqlKind.FUNC_SUBSTR, funcSubStringCompile);
        scalarProduceMap.put(SqlKind.FUNC_CAST, funcCastCompile);
        scalarProduceMap.put(SqlKind.FUNC_TO_CHAR, funcToCharCompile);
        scalarProduceMap.put(SqlKind.FUNC_TO_DATE, funcToDateCompile);
        scalarProduceMap.put(SqlKind.FUNC_TO_TIME, funcToTimeCompile);
        scalarProduceMap.put(SqlKind.FUNC_TO_DATETIME, funcToDateTimeCompile);
        scalarProduceMap.put(SqlKind.FUNC_TO_DECIMAL, funcToDecimalCompile);
        scalarProduceMap.put(SqlKind.FUNC_VERSION, funcVersionCompile);
        scalarProduceMap.put(SqlKind.FUNC_CURRENT_USER, funcCurrentUserCompile);
        scalarProduceMap.put(SqlKind.FUNC_CURRENT_SCHEMA, funcCurrentSchemaCompile);
        scalarProduceMap.put(SqlKind.FUNC_DATE_ADD, funcDateAddCompile);
        scalarProduceMap.put(SqlKind.FUNC_DATE_SUB, funcDateSubCompile);
        scalarProduceMap.put(SqlKind.FUNC_ADD_WEEKS, funcAddWeeksCompile);
        scalarProduceMap.put(SqlKind.FUNC_SUB_WEEKS, funcSubWeeksCompile);
        scalarProduceMap.put(SqlKind.FUNC_ADD_MONTHS, funcAddMonthsCompile);
        scalarProduceMap.put(SqlKind.FUNC_SUB_MONTHS, funcSubMonthsCompile);
        scalarProduceMap.put(SqlKind.FUNC_ADD_YEARS, funcAddYearsCompile);
        scalarProduceMap.put(SqlKind.FUNC_SUB_YEARS, funcSubYearsCompile);
    }

    private static class UnaryCompile
    implements ScalarProduce {
        private UnaryCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexLiteral literal = call.getOperand(0).cast(RexLiteral.class);
            RexNode value = call.getOperand(1);
            return new Unary((String)literal.getValue(), compiler.compile(value));
        }
    }

    private static class AddCompile
    implements ScalarProduce {
        private AddCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new Add(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class SubtractCompile
    implements ScalarProduce {
        private SubtractCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new Subtract(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class MultiplyCompile
    implements ScalarProduce {
        private MultiplyCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new Multiply(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class DivideCompile
    implements ScalarProduce {
        private DivideCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new Divide(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class ModCompile
    implements ScalarProduce {
        private ModCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new Mod(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class AndCompile
    implements ScalarProduce {
        private AndCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new And(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class OrCompile
    implements ScalarProduce {
        private OrCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new OR(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class NotCompile
    implements ScalarProduce {
        private NotCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode rexNode = call.getOperand(0);
            if (rexNode == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new Not(compiler.compile(rexNode));
        }
    }

    private static class EqualsCompile
    implements ScalarProduce {
        private EqualsCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new Equals(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class NotEqualsCompile
    implements ScalarProduce {
        private NotEqualsCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new NotEquals(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class LessThanCompile
    implements ScalarProduce {
        private LessThanCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new LT(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class LessThanOrEqualsCompile
    implements ScalarProduce {
        private LessThanOrEqualsCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new LTE(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class GreaterThanCompile
    implements ScalarProduce {
        private GreaterThanCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new GT(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class GreaterThanOrEqualsCompile
    implements ScalarProduce {
        private GreaterThanOrEqualsCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new GTE(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class IsNullCompile
    implements ScalarProduce {
        private IsNullCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode rexNode = call.getOperand(0);
            if (rexNode == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new IsNullOrNot(compiler.compile(rexNode), true);
        }
    }

    private static class IsNotNullCompile
    implements ScalarProduce {
        private IsNotNullCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode rexNode = call.getOperand(0);
            if (rexNode == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new IsNullOrNot(compiler.compile(rexNode), false);
        }
    }

    private static class InCompile
    implements ScalarProduce {
        private InCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            ArrayList<ScalarEvaluation> rightScalarEvaluations = new ArrayList<ScalarEvaluation>();
            if (r instanceof RexNodeList) {
                Iterator<RexNode> iterator = ((RexNodeList)r).iterator();
                while (iterator.hasNext()) {
                    rightScalarEvaluations.add(compiler.compile(iterator.next()));
                }
            } else {
                rightScalarEvaluations.add(compiler.compile(r));
            }
            return new InListOrNot(compiler.compile(l), rightScalarEvaluations, true);
        }
    }

    private static class NotInCompile
    implements ScalarProduce {
        private NotInCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            ArrayList<ScalarEvaluation> rightScalarEvaluations = new ArrayList<ScalarEvaluation>();
            if (r instanceof RexNodeList) {
                Iterator<RexNode> iterator = ((RexNodeList)r).iterator();
                while (iterator.hasNext()) {
                    rightScalarEvaluations.add(compiler.compile(iterator.next()));
                }
            } else {
                rightScalarEvaluations.add(compiler.compile(r));
            }
            return new InListOrNot(compiler.compile(l), rightScalarEvaluations, false);
        }
    }

    private static class LikeCompile
    implements ScalarProduce {
        private LikeCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new LikeOrNot(compiler.compile(l), compiler.compile(r), true);
        }
    }

    private static class NotLikeCompile
    implements ScalarProduce {
        private NotLikeCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new LikeOrNot(compiler.compile(l), compiler.compile(r), false);
        }
    }

    private static class CaseWhenCompile
    implements ScalarProduce {
        private CaseWhenCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexLiteral type = call.getOperand(0).cast(RexLiteral.class);
            SqlCaseWhenType caseWhenType = SqlCaseWhenType.valueOf(type.getValue().toString());
            int whenOperand = 2;
            int thenOperand = 3;
            int elseOperand = 4;
            if (SqlCaseWhenType.SearchedCase == caseWhenType) {
                whenOperand = 1;
                thenOperand = 2;
                elseOperand = 3;
            }
            RexNodeList whens = call.getOperand(whenOperand).cast(RexNodeList.class);
            RexNodeList thens = call.getOperand(thenOperand).cast(RexNodeList.class);
            RexNode els = call.getOperand(elseOperand);
            assert (thens.size() == whens.size());
            ArrayList<ScalarEvaluation> whenScalarEvaluations = new ArrayList<ScalarEvaluation>(whens.size());
            ArrayList<ScalarEvaluation> thenScalarEvaluations = new ArrayList<ScalarEvaluation>(thens.size());
            ScalarEvaluation valueScalarEvaluations = null;
            if (SqlCaseWhenType.SimpleCase == caseWhenType) {
                valueScalarEvaluations = compiler.compile(call.getOperand(1));
            }
            for (int i = 0; i < whens.size(); ++i) {
                whenScalarEvaluations.add(compiler.compile(whens.get(i)));
                thenScalarEvaluations.add(compiler.compile(thens.get(i)));
            }
            return new CaseWhen(caseWhenType, valueScalarEvaluations, whenScalarEvaluations, thenScalarEvaluations, compiler.compile(els));
        }
    }

    private static class FuncAndCompile
    implements ScalarProduce {
        private FuncAndCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new And(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class FuncOrCompile
    implements ScalarProduce {
        private FuncOrCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new OR(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class FuncXorCompile
    implements ScalarProduce {
        private FuncXorCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new XOR(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class FuncAbsCompile
    implements ScalarProduce {
        private FuncAbsCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            if (l == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new Abs(compiler.compile(l));
        }
    }

    private static class FuncModCompile
    implements ScalarProduce {
        private FuncModCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new Mod(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class FuncCeilCompile
    implements ScalarProduce {
        private FuncCeilCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            if (l == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new Ceiling(compiler.compile(l));
        }
    }

    private static class FuncFloorCompile
    implements ScalarProduce {
        private FuncFloorCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            if (l == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new Floor(compiler.compile(l));
        }
    }

    private static class FuncConcatCompile
    implements ScalarProduce {
        private FuncConcatCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            List<RexNode> operands = call.getOperands();
            ArrayList<ScalarEvaluation> scalarEvaluations = new ArrayList<ScalarEvaluation>(operands.size());
            for (RexNode operand : operands) {
                if (operand == null) {
                    throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
                }
                scalarEvaluations.add(compiler.compile(operand));
            }
            return new Concat(scalarEvaluations.toArray(new ScalarEvaluation[0]));
        }
    }

    private static class FuncLengthCompile
    implements ScalarProduce {
        private FuncLengthCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            if (l == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new Length(compiler.compile(l));
        }
    }

    private static class FuncLowerCompile
    implements ScalarProduce {
        private FuncLowerCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            if (l == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new Lower(compiler.compile(l));
        }
    }

    private static class FuncUpperCompile
    implements ScalarProduce {
        private FuncUpperCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            if (l == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new Upper(compiler.compile(l));
        }
    }

    private static class FuncSubStringCompile
    implements ScalarProduce {
        private FuncSubStringCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode m = call.getOperand(1);
            RexNode r = call.getOperand(2);
            if (l == null || m == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new SubString(compiler.compile(l), compiler.compile(m), compiler.compile(r));
        }
    }

    private static class FuncCastCompile
    implements ScalarProduce {
        private FuncCastCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            DataType type = call.getType();
            if (l == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new Cast(compiler.compile(l), type);
        }
    }

    private static class FuncSubYearsCompile
    implements ScalarProduce {
        private FuncSubYearsCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new SubYears(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class FuncAddYearsCompile
    implements ScalarProduce {
        private FuncAddYearsCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new AddYears(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class FuncSubMonthsCompile
    implements ScalarProduce {
        private FuncSubMonthsCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new SubMonths(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class FuncAddMonthsCompile
    implements ScalarProduce {
        private FuncAddMonthsCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new AddMonths(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class FuncSubWeeksCompile
    implements ScalarProduce {
        private FuncSubWeeksCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new SubWeeks(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class FuncAddWeeksCompile
    implements ScalarProduce {
        private FuncAddWeeksCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new AddWeeks(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class FuncDateSubCompile
    implements ScalarProduce {
        private FuncDateSubCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new DateSub(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class FuncDateAddCompile
    implements ScalarProduce {
        private FuncDateAddCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new DateAdd(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class FuncToCharCompile
    implements ScalarProduce {
        private FuncToCharCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            RexNode r = call.getOperand(1);
            if (l == null || r == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new ToChar(compiler.compile(l), compiler.compile(r));
        }
    }

    private static class FuncToDateCompile
    implements ScalarProduce {
        private FuncToDateCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            if (l == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new ToDate(compiler.compile(l));
        }
    }

    private static class FuncToTimeCompile
    implements ScalarProduce {
        private FuncToTimeCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            if (l == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new ToTime(compiler.compile(l));
        }
    }

    private static class FuncToDateTimeCompile
    implements ScalarProduce {
        private FuncToDateTimeCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            if (l == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new ToDatetime(compiler.compile(l));
        }
    }

    private static class FuncToDecimalCompile
    implements ScalarProduce {
        private FuncToDecimalCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            RexNode l = call.getOperand(0);
            if (l == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCompilerNull, (Object[])new Object[0]);
            }
            return new ToDecimal(compiler.compile(l));
        }
    }

    private static class FuncVersionCompile
    implements ScalarProduce {
        private FuncVersionCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            return new Version();
        }
    }

    private static class FuncCurrentUserCompile
    implements ScalarProduce {
        private FuncCurrentUserCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            return new CurrentUser();
        }
    }

    private static class FuncCurrentSchemaCompile
    implements ScalarProduce {
        private FuncCurrentSchemaCompile() {
        }

        @Override
        public ScalarEvaluation produce(RexCall call, ScalarEvaluationCompiler compiler) {
            return new CurrentSchema();
        }
    }

    @FunctionalInterface
    public static interface ScalarProduce {
        public ScalarEvaluation produce(RexCall var1, ScalarEvaluationCompiler var2);
    }
}

