/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter;

import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.flydb.common.ServerConfig;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.common.config.Options;
import kd.bos.flydb.common.config.RedisConfiguration;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.Context;
import kd.bos.flydb.core.Contexts;
import kd.bos.flydb.core.interpreter.Executor;
import kd.bos.flydb.core.sql.tree.SqlLiteral;
import kd.bos.flydb.core.sql.tree.SqlSetVariable;

public class SetVariableExecutor
implements Executor {
    private final SqlSetVariable sqlSetVariable;

    public SetVariableExecutor(SqlSetVariable sqlSetVariable) {
        this.sqlSetVariable = sqlSetVariable;
    }

    @Override
    public Executor.Result executeQuery() {
        Context context = Contexts.get();
        RedisConfiguration configuration = ServerConfig.getSessionConfiguration((String)context.getSessionId());
        SqlLiteral key = this.sqlSetVariable.getOperand(SqlSetVariable.KEY_OPERAND).cast(SqlLiteral.class);
        SqlLiteral value = this.sqlSetVariable.getOperand(SqlSetVariable.VALUE_OPERAND).cast(SqlLiteral.class);
        String stringKey = ((String)key.getValue()).trim();
        String stringValue = ((String)value.getValue()).trim();
        Option option = Options.getOption((String)stringKey);
        if (option == null) {
            throw Exceptions.of((ErrorCode)ErrorCode.SetVariableErrorKeyNotExists, (Object[])new Object[]{stringKey});
        }
        try {
            configuration.set(option, stringValue);
        }
        catch (Exception exception) {
            throw Exceptions.of((ErrorCode)ErrorCode.SetVariableErrorValueError, (Object[])new Object[]{stringValue});
        }
        return new Executor.ExecuteResult(new RowMeta(new Field[0]));
    }
}

