/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.algox;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;

public final class AggUtil {
    private AggUtil() {
    }

    public static int compare(Object v1, Object v2) {
        if (v1 == null) {
            if (v2 == null) {
                return 0;
            }
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if (v1 instanceof String) {
            return ((String)v1).compareTo((String)v2);
        }
        if (v1 instanceof Date) {
            return ((Date)v1).compareTo((Date)v2);
        }
        if (v1 instanceof Long) {
            return ((Long)v1).compareTo((Long)v2);
        }
        if (v1 instanceof Double) {
            return ((Double)v1).compareTo((Double)v2);
        }
        if (v1 instanceof BigDecimal) {
            return ((BigDecimal)v1).compareTo((BigDecimal)v2);
        }
        if (v1 instanceof BigInteger) {
            return ((BigInteger)v1).compareTo((BigInteger)v2);
        }
        if (v1 instanceof Number) {
            int i2;
            int i1 = ((Number)v1).intValue();
            if (i1 > (i2 = ((Number)v2).intValue())) {
                return 1;
            }
            if (i1 < i2) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    public static Object add(Object v1, Object v2) {
        if (v1 == null || v2 == null) {
            return v1 == null ? v2 : v1;
        }
        if (v1 instanceof Number && v2 instanceof Number) {
            if (v1 instanceof BigDecimal || v2 instanceof BigDecimal) {
                return AggUtil.toBigDecimal(v1).add(AggUtil.toBigDecimal(v2));
            }
            if (v1 instanceof Double || v2 instanceof Double || v1 instanceof Float || v2 instanceof Float) {
                return ((Number)v1).doubleValue() + ((Number)v2).doubleValue();
            }
            if (v1 instanceof Long || v2 instanceof Long) {
                return ((Number)v1).longValue() + ((Number)v2).longValue();
            }
            return ((Number)v1).intValue() + ((Number)v2).intValue();
        }
        throw Exceptions.of((ErrorCode)ErrorCode.AddError, (Object[])new Object[]{v1.toString(), v2.toString()});
    }

    public static BigDecimal toBigDecimal(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        return new BigDecimal(v.toString());
    }
}

