/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.algox;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.interpreter.algox.AggUtil;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.type.DataType;

public class AggregateFunction
extends GroupReduceFunction {
    private final RowMeta rowMeta;
    private final List<Integer> groupList;
    private final List<AggCall> aggCallList;

    public AggregateFunction(RowMeta rowMeta, List<Integer> groupList, List<AggCall> aggCallList) {
        this.rowMeta = rowMeta;
        this.groupList = groupList;
        this.aggCallList = aggCallList;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        int i;
        Object[] out = new Object[this.groupList.size() + this.aggCallList.size()];
        RowX first = null;
        Iterator<RowX> ite = iterable.iterator();
        Aggregator[] aggs = new Aggregator[this.aggCallList.size()];
        for (i = 0; i < this.aggCallList.size(); ++i) {
            Aggregator[] call = this.aggCallList.get(i);
            aggs[i] = AggregateFunction.getAgg(call.kind, call.index);
        }
        while (ite.hasNext()) {
            RowX item = ite.next();
            if (first == null) {
                first = item;
            }
            for (Aggregator agg : aggs) {
                agg.collect(item.values());
            }
        }
        if (first == null) {
            return;
        }
        for (i = 0; i < this.groupList.size(); ++i) {
            out[i] = first.get(this.groupList.get(i).intValue());
        }
        int offset = this.groupList.size();
        for (int i2 = 0; i2 < aggs.length; ++i2) {
            out[i2 + offset] = aggs[i2].getValue();
        }
        collector.collect(new RowX(out));
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private static Aggregator getAgg(SqlKind kind, int index) {
        switch (kind) {
            case FUNC_COUNT: {
                return new Count();
            }
            case FUNC_SUM: {
                return new Sum(index);
            }
            case FUNC_MAX: {
                return new Max(index);
            }
            case FUNC_MIN: {
                return new Min(index);
            }
        }
        throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedAggregateFunction, (Object[])new Object[]{kind.getName()});
    }

    public static class AggCall
    implements Serializable {
        public final SqlKind kind;
        public final Integer index;
        public final boolean distinct;
        public final boolean ignoreNull;
        public final DataType type;

        public AggCall(SqlKind kind, Integer index, boolean distinct, boolean ignoreNull, DataType type) {
            this.kind = kind;
            this.index = index;
            this.distinct = distinct;
            this.ignoreNull = ignoreNull;
            this.type = type;
        }
    }

    public static class Sum
    implements Aggregator {
        private Object value;
        private final int index;

        public Sum(int index) {
            this.index = index;
        }

        @Override
        public void collect(Object[] row) {
            this.value = AggUtil.add(this.value, row[this.index]);
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    public static class Min
    implements Aggregator {
        private Object value;
        private final int index;

        public Min(int index) {
            this.index = index;
        }

        @Override
        public void collect(Object[] row) {
            if (this.value == null) {
                this.value = row[this.index];
                return;
            }
            if (AggUtil.compare(this.value, row[this.index]) > 0) {
                this.value = row[this.index];
            }
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    public static class Max
    implements Aggregator {
        private Object value;
        private final int index;

        public Max(int index) {
            this.index = index;
        }

        @Override
        public void collect(Object[] row) {
            if (AggUtil.compare(this.value, row[this.index]) < 0) {
                this.value = row[this.index];
            }
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    public static class Count
    implements Aggregator {
        private long count = 0L;

        @Override
        public void collect(Object[] row) {
            ++this.count;
        }

        @Override
        public Object getValue() {
            return this.count;
        }
    }

    public static interface Aggregator
    extends Serializable {
        public void collect(Object[] var1);

        public Object getValue();
    }
}

