/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.algox;

import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.type.DataTypeField;
import kd.bos.flydb.core.sql.type.SqlTypeName;

public final class CompilerHelp {
    private CompilerHelp() {
    }

    public static RowMeta convertRowType(kd.bos.flydb.core.sql.type.DataType type) {
        if (!type.isStruct()) {
            throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_TypeConvertError, (Object[])new Object[0]);
        }
        List<DataTypeField> fieldList = type.getFieldList();
        String[] names = new String[fieldList.size()];
        DataType[] types = new DataType[fieldList.size()];
        for (int i = 0; i < fieldList.size(); ++i) {
            DataTypeField field = fieldList.get(i);
            names[i] = field.getName();
            types[i] = CompilerHelp.convertBasicType(field.getType());
        }
        return new RowMeta(names, types);
    }

    public static DataType convertBasicType(kd.bos.flydb.core.sql.type.DataType type) {
        if (type.getTypeName() == SqlTypeName.STRUCT) {
            throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_TypeConvertError1, (Object[])new Object[0]);
        }
        SqlTypeName typeName = type.getTypeName();
        switch (typeName) {
            case INT: {
                return DataType.IntegerType;
            }
            case LONG: {
                return DataType.LongType;
            }
            case DECIMAL: {
                return DataType.BigDecimalType;
            }
            case STRING: {
                return DataType.StringType;
            }
            case DATETIME: {
                return DataType.TimestampType;
            }
            case DATE: {
                return DataType.DateType;
            }
            case BOOLEAN: {
                return DataType.BooleanType;
            }
            case NULL: {
                return DataType.NullType;
            }
            case UNKNOWN: {
                return DataType.UnknownType;
            }
        }
        throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_UnknownType, (Object[])new Object[]{type.getTypeName()});
    }

    public static String getFieldName(DataSetX source, int index) {
        return source.getRowMeta().getField(index).getName();
    }
}

