/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.algox;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import kd.bos.algo.CustomizedOutput;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.flydb.core.interpreter.algox.DataSetOutputManagers;
import kd.bos.flydb.core.interpreter.algox.DataSetWriter;
import kd.bos.flydb.core.sql.util.Pair;

public class DataSetOutput
implements CustomizedOutput {
    private final RowMeta rowMeta;
    private final String id;
    private final List<String> subqueryIdList;
    private transient DataSetWriter writer;
    private transient RowCorrecter correcter;

    public DataSetOutput(RowMeta rowMeta, List<String> subqueryIdList) {
        this.rowMeta = rowMeta;
        this.id = UUID.randomUUID().toString().replaceAll("-", "");
        this.subqueryIdList = subqueryIdList;
    }

    public void open() {
        this.writer = DataSetOutputManagers.get().createWriter(this.id, this.rowMeta);
        this.correcter = new RowCorrecter(this.rowMeta);
    }

    public void write(Object[] row) {
        this.writer.write(this.correcter.correct(row));
    }

    public void close() {
        this.writer.close();
        if (this.subqueryIdList != null && !this.subqueryIdList.isEmpty()) {
            for (String id : this.subqueryIdList) {
                DataSetOutputManagers.get().deleteDataSet(id);
            }
        }
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public boolean isSingleParallel() {
        return true;
    }

    public String getId() {
        return this.id;
    }

    private static class RowCorrecter
    implements Correcter<Object[]> {
        private final Pair<Integer, Correcter<Object>>[] correcters;

        public RowCorrecter(RowMeta rowMeta) {
            ArrayList<Pair<Integer, TimestampCorrecter>> list = new ArrayList<Pair<Integer, TimestampCorrecter>>(rowMeta.getFieldCount());
            for (int i = 0; i < rowMeta.getDataTypes().length; ++i) {
                if (rowMeta.getDataType((int)i).ordinal != DataType.TimestampType.ordinal) continue;
                list.add(new Pair<Integer, TimestampCorrecter>(i, TimestampCorrecter.INSTANCE));
            }
            this.correcters = list.toArray(new Pair[0]);
        }

        @Override
        public Object[] correct(Object[] input) {
            if (this.correcters == null) {
                return input;
            }
            for (Pair<Integer, Correcter<Object>> correcter : this.correcters) {
                input[correcter.getType().intValue()] = correcter.getValue().correct(input[correcter.getType()]);
            }
            return input;
        }
    }

    private static class TimestampCorrecter
    implements Correcter<Object> {
        private static final TimestampCorrecter INSTANCE = new TimestampCorrecter();

        private TimestampCorrecter() {
        }

        @Override
        public Object correct(Object input) {
            if (input == null) {
                return null;
            }
            if (input instanceof Timestamp) {
                return input;
            }
            if (input instanceof Date) {
                return new Timestamp(((Date)input).getTime());
            }
            return input;
        }
    }

    static interface Correcter<T> {
        public T correct(T var1);
    }
}

