/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.algox;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.OperationContext;
import kd.bos.context.OperationContextCreator;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.flydb.common.ServerConfig;
import kd.bos.flydb.common.ServerOption;
import kd.bos.flydb.common.config.Configuration;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.core.interpreter.algox.DataSetOutputManagers;
import kd.bos.thread.ThreadLifeCycleManager;

public class DataSetOutputCleanService {
    private static final AtomicBoolean start = new AtomicBoolean(false);

    public static void start() {
        if (start.compareAndSet(false, true)) {
            Elector elector = ElectFactory.getElector((String)("flydb." + DataSetOutputCleanService.class.getName()));
            elector.registerListener((ElectorListener)new CleanListener());
            elector.start();
        }
    }

    public static void clean() {
        Configuration configuration = ServerConfig.getSysConfiguration();
        int timeoutHours = configuration.getInt((Option)ServerOption.AlgoXOutputMaxLifeTime);
        DataSetOutputManagers.get().cleanExpiredDataSet(timeoutHours);
    }

    public static class Runnable1
    implements Runnable {
        private Runnable delegate;

        public Runnable1(Runnable delegate) {
            this.delegate = delegate;
            this.delegate = ThreadLifeCycleManager.wrapRunnable((Runnable)delegate);
        }

        @Override
        public void run() {
            try {
                OperationContext.remove();
                OperationContextCreator.getOrCreateForBos();
            }
            catch (Exception exception) {
            }
            finally {
                this.delegate.run();
            }
        }
    }

    public static class CleanListener
    implements ElectorListener {
        private ScheduledExecutorService scheduledExecutorService;

        public void notifyMaster() {
            if (this.scheduledExecutorService == null) {
                this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(r -> {
                    Runnable1 runnable = new Runnable1(r);
                    Thread mainThread = new Thread(runnable);
                    mainThread.setDaemon(true);
                    mainThread.setName("FlyDB-DataSetOutput-Clean");
                    return mainThread;
                });
                this.scheduledExecutorService.scheduleWithFixedDelay(DataSetOutputCleanService::clean, 0L, 1L, TimeUnit.HOURS);
            }
        }

        public void notifyLostMaster() {
            if (this.scheduledExecutorService != null) {
                this.scheduledExecutorService.shutdown();
                this.scheduledExecutorService = null;
            }
        }
    }
}

