/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.algox;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.SettableArrayRow;
import kd.bos.flydb.common.ServerConfig;
import kd.bos.flydb.common.ServerOption;
import kd.bos.flydb.common.config.Configuration;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.interpreter.algox.DataSetReader;
import kd.bos.flydb.core.interpreter.algox.DataSetWriter;
import kd.bos.flydb.core.interpreter.algox.io.DataSetChannel;
import kd.bos.flydb.core.interpreter.algox.io.DataSetIOManager;
import kd.bos.flydb.core.interpreter.algox.io.DataSetStorageManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DataSetOutputManager {
    private static final Log log = LogFactory.getLog(DataSetOutputManager.class);
    private final DataSetStorageManager manager;

    public DataSetOutputManager() {
        String basePath = ServerConfig.getSysConfiguration().getString((Option)ServerOption.OutputPath);
        if (basePath == null) {
            basePath = ServerConfig.getSysConfiguration().getString((Option)ServerOption.DiskCachePath);
        }
        if (basePath == null || basePath.trim().isEmpty()) {
            throw Exceptions.of((ErrorCode)ErrorCode.ServerError_UnexpectedException, (Object[])new Object[]{"Miss configuration: diskcache.path , please configure the value of the 'diskcache.path' as a shared disk path"});
        }
        Configuration configuration = ServerConfig.getSysConfiguration();
        int bufSize = configuration.getInt((Option)ServerOption.OutputBufferSize);
        int batchCount = configuration.getInt((Option)ServerOption.OutputBatchCount);
        DataSetIOManager ioManager = new DataSetIOManager(basePath);
        this.manager = new DataSetStorageManager(ioManager, bufSize, batchCount);
    }

    public DataSetOutputManager(DataSetStorageManager dataSetStorageManager) {
        this.manager = dataSetStorageManager;
    }

    public DataSetWriter createWriter(String id, RowMeta rowMeta) {
        DataSetChannel channel = this.manager.createChannel(id, rowMeta);
        try {
            DataSetStorageManager.Writer writer = this.manager.createWriter(channel);
            return new Writer(writer);
        }
        catch (IOException e) {
            throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_CreateOutputFileError, (Object[])new Object[]{e.getMessage()});
        }
    }

    public DataSetReader createReader(String id) {
        DataSetChannel channel = null;
        try {
            channel = this.manager.getChannel(id);
            DataSetStorageManager.Reader reader = this.manager.createReader(channel);
            RowMeta rowMeta = channel.getRowMeta();
            long count = channel.getCount();
            return new Reader(count, rowMeta, reader);
        }
        catch (IOException e) {
            throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_ReadOutputFileError, (Object[])new Object[]{e.getMessage()});
        }
    }

    public void cleanExpiredDataSet(int hours) {
        try {
            this.manager.cleanExpired(hours);
        }
        catch (Exception e) {
            log.warn("FlyDB_Error: clean expired output file cause an exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void deleteDataSet(String id) {
        try {
            this.manager.delete(id);
        }
        catch (Exception e) {
            log.warn("FlyDB_Error: delete output file cause an exception: " + e.getMessage(), (Throwable)e);
        }
    }

    private static class Reader
    implements DataSetReader {
        private final long count;
        private final RowMeta rowMeta;
        private final DataSetStorageManager.Reader reader;

        public Reader(long count, RowMeta rowMeta, DataSetStorageManager.Reader reader) {
            this.count = count;
            this.rowMeta = rowMeta;
            this.reader = reader;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public RowMeta getRowMeta() {
            return this.rowMeta;
        }

        @Override
        public List<Row> read(int limit, int offset) {
            try {
                Iterator<Object[]> iterator = this.reader.createReaderIterator(limit, offset);
                ArrayList<Row> rows = new ArrayList<Row>(limit);
                while (iterator.hasNext()) {
                    rows.add((Row)new SettableArrayRow(this.rowMeta, iterator.next(), false));
                }
                return rows;
            }
            catch (IOException e) {
                throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_ReadOutputFileError, (Object[])new Object[]{e.getMessage()});
            }
        }

        @Override
        public List<Object> read(int limit, int offset, int index) {
            try {
                Iterator<Object[]> iterator = this.reader.createReaderIterator(limit, offset);
                ArrayList<Object> rows = new ArrayList<Object>(limit);
                while (iterator.hasNext()) {
                    rows.add(iterator.next()[index]);
                }
                return rows;
            }
            catch (IOException e) {
                throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_ReadOutputFileError, (Object[])new Object[]{e.getMessage()});
            }
        }

        @Override
        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_ReadOutputFileError, (Object[])new Object[]{e.getMessage()});
            }
        }
    }

    private static class Writer
    implements DataSetWriter {
        private final DataSetStorageManager.Writer writer;

        public Writer(DataSetStorageManager.Writer writer) {
            this.writer = writer;
        }

        @Override
        public void write(Object[] row) {
            try {
                this.writer.write(row);
            }
            catch (IOException e) {
                throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_WriteOutputFileError, (Object[])new Object[]{e.getMessage()});
            }
        }

        @Override
        public void close() {
            try {
                this.writer.close();
            }
            catch (IOException ioException) {
                throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_WriteOutputFileError, (Object[])new Object[]{ioException.getMessage()});
            }
        }
    }
}

