/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.algox;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import kd.bos.algo.AlgoException;
import kd.bos.algo.RowMeta;
import kd.bos.algo.serde.RawRowSerde;
import kd.bos.algo.util.memory.DataInputView;
import kd.bos.algo.util.memory.DataOutputView;

public class RowSerializer {
    private final RowMeta rowMeta;
    private final int arity;
    private boolean[] nullMask;

    public RowSerializer(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.arity = rowMeta.getFieldCount();
        this.nullMask = new boolean[this.arity];
    }

    public void serialize(Object[] row, DataOutputView target) throws IOException {
        try {
            RawRowSerde.writeNullMask((int)row.length, (Object[])row, (DataOutput)target);
            for (int i = 0; i < row.length; ++i) {
                if (row[i] == null) continue;
                this.rowMeta.getFieldDataType(i).write(row[i], (DataOutput)target);
            }
        }
        catch (IOException e) {
            throw new AlgoException((Throwable)e);
        }
    }

    public Object[] deserialize(DataInputView source) throws IOException {
        try {
            RawRowSerde.readIntoNullMask((int)this.arity, (DataInput)source, (boolean[])this.nullMask);
            Object[] values = new Object[this.arity];
            for (int i = 0; i < values.length; ++i) {
                if (this.nullMask[i]) continue;
                values[i] = this.rowMeta.getFieldDataType(i).read((DataInput)source);
            }
            return values;
        }
        catch (IOException e) {
            throw new AlgoException((Throwable)e);
        }
    }
}

