/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.algox.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kd.bos.flydb.core.interpreter.algox.io.AsynchronousIOCallback;
import kd.bos.flydb.core.interpreter.algox.io.AsynchronousIORequest;
import kd.bos.flydb.core.interpreter.algox.io.WriterRequest;

public class AsynchronousWriter
implements AsynchronousIOCallback,
AutoCloseable {
    private final List<CompletableFuture<?>> futureList;
    private final ArrayBlockingQueue<WriterRequest> queue;
    private IOException ioe = null;

    public AsynchronousWriter(ArrayBlockingQueue<WriterRequest> queue) {
        this.queue = queue;
        this.futureList = Collections.synchronizedList(new ArrayList(queue.size()));
    }

    public void write(WriterRequest request) throws IOException {
        this.checkIOException();
        try {
            this.queue.put(request);
            this.futureList.add(request.getFuture());
        }
        catch (InterruptedException e) {
            throw new IOException("Write error, Thread has interrupted.", e);
        }
    }

    @Override
    public void done(AsynchronousIORequest request, IOException ioe) {
        this.futureList.remove(request.getFuture());
        if (ioe != null) {
            this.ioe = ioe;
        }
    }

    private void checkIOException() throws IOException {
        if (this.ioe != null) {
            throw this.ioe;
        }
    }

    @Override
    public void close() throws IOException {
        this.checkIOException();
        if (!this.futureList.isEmpty()) {
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf(this.futureList.toArray(new CompletableFuture[0]));
            try {
                completableFuture.get();
            }
            catch (InterruptedException e) {
                throw new IOException("Write error, Thread has interrupted.", e);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
    }
}

