/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.algox.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kd.bos.algo.util.memory.DataInputView;
import kd.bos.flydb.core.interpreter.algox.io.AsynchronousIOCallback;
import kd.bos.flydb.core.interpreter.algox.io.AsynchronousReader;
import kd.bos.flydb.core.interpreter.algox.io.ReaderRequest;
import org.jetbrains.annotations.NotNull;

public class ChannelReaderInputView
implements DataInputView,
AutoCloseable {
    private final AsynchronousReader reader;
    private final int bufSize;
    private final FileChannel fileChannel;
    private ByteBuffer byteBuf;
    private byte[] bytearr = new byte[80];
    private char[] chararr = new char[80];
    private byte[] readBuffer = new byte[8];
    private char[] lineBuffer;

    public ChannelReaderInputView(AsynchronousReader reader, int bufSize, String path) throws IOException {
        this.reader = reader;
        this.bufSize = bufSize;
        this.fileChannel = new RandomAccessFile(new File(path), "r").getChannel();
        this.byteBuf = ByteBuffer.allocate(bufSize);
        this.byteBuf.flip();
    }

    private void sendRequest() throws IOException {
        this.byteBuf.clear();
        ByteReaderRequest request = new ByteReaderRequest(this.reader, this.byteBuf, this.fileChannel);
        this.reader.read(request);
        try {
            request.getFuture().get();
            this.byteBuf.flip();
        }
        catch (InterruptedException e) {
            throw new IOException("IO Reader has be interrupted.");
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
    }

    public void seek(long position) throws IOException {
        SeekReaderRequest request = new SeekReaderRequest(this.reader, position, this.fileChannel);
        this.reader.read(request);
        try {
            request.getFuture().get();
            this.byteBuf.clear();
            this.byteBuf.flip();
        }
        catch (InterruptedException e) {
            throw new IOException("IO Reader has be interrupted.");
        }
        catch (ExecutionException e) {
            Throwable exception = e.getCause();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception);
        }
    }

    public void skipBytesToRead(int i) throws IOException {
        this.skipBytes(i);
    }

    public int read(byte[] bytes, int i, int i1) throws IOException {
        throw new UnsupportedEncodingException("Unsupported skipBytesToRead");
    }

    public int read(byte[] bytes) throws IOException {
        throw new UnsupportedEncodingException("Unsupported skipBytesToRead");
    }

    public void readFully(@NotNull byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(@NotNull byte[] b, int off, int len) throws IOException {
        int remaining = this.byteBuf.remaining();
        if (remaining >= len) {
            this.byteBuf.get(b, off, len);
        } else {
            if (remaining > 0) {
                this.byteBuf.get(b, off, remaining);
            }
            this.sendRequest();
            this.readFully(b, off + remaining, len - remaining);
        }
    }

    public int skipBytes(int n) throws IOException {
        int c = 0;
        for (int i = 0; i < n; ++i) {
            try {
                this.readByte();
                ++c;
                continue;
            }
            catch (EOFException eofException) {
                return c;
            }
        }
        return n;
    }

    public boolean readBoolean() throws IOException {
        int b = this.readByte2Int();
        return b != 0;
    }

    private int readByte2Int() throws IOException {
        return this.readByte() & 0xFF;
    }

    public byte readByte() throws IOException {
        if (this.byteBuf.hasRemaining()) {
            return this.byteBuf.get();
        }
        this.sendRequest();
        return this.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.readByte2Int();
    }

    public short readShort() throws IOException {
        int ch1 = this.readByte2Int();
        int ch2 = this.readByte2Int();
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int readUnsignedShort() throws IOException {
        int ch1 = this.readByte2Int();
        int ch2 = this.readByte2Int();
        return (ch1 << 8) + (ch2 << 0);
    }

    public char readChar() throws IOException {
        int ch1 = this.readByte2Int();
        int ch2 = this.readByte2Int();
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public int readInt() throws IOException {
        int ch1 = this.readByte2Int();
        int ch2 = this.readByte2Int();
        int ch3 = this.readByte2Int();
        int ch4 = this.readByte2Int();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public long readLong() throws IOException {
        this.readFully(this.readBuffer, 0, 8);
        return ((long)this.readBuffer[0] << 56) + ((long)(this.readBuffer[1] & 0xFF) << 48) + ((long)(this.readBuffer[2] & 0xFF) << 40) + ((long)(this.readBuffer[3] & 0xFF) << 32) + ((long)(this.readBuffer[4] & 0xFF) << 24) + (long)((this.readBuffer[5] & 0xFF) << 16) + (long)((this.readBuffer[6] & 0xFF) << 8) + (long)((this.readBuffer[7] & 0xFF) << 0);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        int c;
        char[] buf = this.lineBuffer;
        if (buf == null) {
            buf = this.lineBuffer = new char[128];
        }
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            c = this.readByte2Int();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = this.readByte2Int();
                    if (c2 == 10 || c2 == -1) break block4;
                    this.byteBuf.position(this.byteBuf.position() - 1);
                    break block4;
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(this.lineBuffer, 0, buf, 0, offset);
                        this.lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        if (c == -1 && offset == 0) {
            return null;
        }
        return String.copyValueOf(buf, 0, offset);
    }

    @NotNull
    public String readUTF() throws IOException {
        return ChannelReaderInputView.readUTF((DataInput)((Object)this));
    }

    public static final String readUTF(DataInput in) throws IOException {
        int c;
        int count;
        int utflen = in.readUnsignedShort();
        byte[] bytearr = null;
        char[] chararr = null;
        if (in instanceof ChannelReaderInputView) {
            ChannelReaderInputView dis = (ChannelReaderInputView)((Object)in);
            if (dis.bytearr.length < utflen) {
                dis.bytearr = new byte[utflen * 2];
                dis.chararr = new char[utflen * 2];
            }
            chararr = dis.chararr;
            bytearr = dis.bytearr;
        } else {
            bytearr = new byte[utflen];
            chararr = new char[utflen];
        }
        int chararr_count = 0;
        in.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            int c2 = bytearr[count] & 0xFF;
            switch (c2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c2;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c2 & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c2 & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararr_count);
    }

    @Override
    public void close() throws IOException {
        IOException ioe = null;
        try {
            this.reader.close();
        }
        catch (IOException ioException) {
            ioe = ioException;
        }
        try {
            this.fileChannel.close();
        }
        catch (IOException ioException) {
            ioe = ioException;
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    private static class ByteReaderRequest
    implements ReaderRequest {
        private final AsynchronousReader reader;
        private final ByteBuffer buf;
        private final CompletableFuture<Void> future;
        private final FileChannel fileChannel;

        public ByteReaderRequest(AsynchronousReader reader, ByteBuffer buf, FileChannel fileChannel) {
            this.reader = reader;
            this.buf = buf;
            this.future = new CompletableFuture();
            this.fileChannel = fileChannel;
        }

        @Override
        public void read() throws IOException {
            int byteRead = this.fileChannel.read(this.buf);
            while (byteRead != -1 && this.buf.hasRemaining()) {
                byteRead = this.fileChannel.read(this.buf);
            }
        }

        @Override
        public CompletableFuture<?> getFuture() {
            return this.future;
        }

        @Override
        public AsynchronousIOCallback getCallback() {
            return this.reader;
        }
    }

    private static class SeekReaderRequest
    implements ReaderRequest {
        private final AsynchronousReader reader;
        private final long position;
        private final CompletableFuture<Void> future;
        private final FileChannel fileChannel;

        public SeekReaderRequest(AsynchronousReader reader, long position, FileChannel fileChannel) {
            this.reader = reader;
            this.position = position;
            this.future = new CompletableFuture();
            this.fileChannel = fileChannel;
        }

        @Override
        public void read() throws IOException {
            this.fileChannel.position(this.position);
        }

        @Override
        public CompletableFuture<?> getFuture() {
            return this.future;
        }

        @Override
        public AsynchronousIOCallback getCallback() {
            return this.reader;
        }
    }
}

