/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.algox.io;

import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kd.bos.algo.util.memory.DataInputView;
import kd.bos.algo.util.memory.DataOutputView;
import kd.bos.flydb.core.interpreter.algox.io.AsynchronousIOCallback;
import kd.bos.flydb.core.interpreter.algox.io.AsynchronousWriter;
import kd.bos.flydb.core.interpreter.algox.io.WriterRequest;
import org.jetbrains.annotations.NotNull;

public class ChannelWriterOutputView
implements DataOutputView,
AutoCloseable {
    private final AsynchronousWriter writer;
    private final int bufSize;
    private final FileChannel fileChannel;
    private ByteBuffer buf;
    private long position = 0L;
    private byte[] bytearr = null;
    private byte[] writeBuffer = new byte[8];

    public ChannelWriterOutputView(AsynchronousWriter writer, int bufSize, String path) throws IOException {
        this.writer = writer;
        this.bufSize = bufSize;
        this.buf = ByteBuffer.allocate(bufSize);
        this.fileChannel = new RandomAccessFile(new File(path), "rw").getChannel();
    }

    public void seek(long position) throws IOException {
        this.sendRequest();
        SeekRequest request = new SeekRequest(this.writer, position, this.fileChannel);
        this.writer.write(request);
        try {
            request.getFuture().get();
        }
        catch (InterruptedException e) {
            throw new IOException("IO Writer has interrupted.", e);
        }
        catch (ExecutionException e) {
            Throwable exception = e.getCause();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception);
        }
        this.position = position;
    }

    public long getPosition() {
        return this.position;
    }

    private void sendRequest() throws IOException {
        ByteWriterRequest request = new ByteWriterRequest(this.buf, this.writer, this.fileChannel);
        this.buf = ByteBuffer.allocate(this.bufSize);
        this.writer.write(request);
    }

    private void incPosition(int inc) {
        this.position += (long)inc;
    }

    public void skipBytesToWrite(int i) throws IOException {
        throw new UnsupportedEncodingException("unsupported skipBytesToWrite");
    }

    public void write(DataInputView dataInputView, int i) throws IOException {
        throw new UnsupportedEncodingException("unsupported skipBytesToWrite");
    }

    public void write(int b) throws IOException {
        if (this.buf.hasRemaining()) {
            this.buf.put((byte)b);
            this.incPosition(1);
        } else {
            this.sendRequest();
            this.write(b);
        }
    }

    public void write(@NotNull byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        if (this.buf.remaining() >= len) {
            this.buf.put(b, off, len);
            this.incPosition(len);
        } else {
            int bufLen = this.buf.remaining();
            int nextOffset = bufLen + off;
            this.buf.put(b, off, bufLen);
            this.incPosition(bufLen);
            this.sendRequest();
            this.write(b, nextOffset, len - bufLen);
        }
    }

    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    public void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeLong(long v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 56);
        this.writeBuffer[1] = (byte)(v >>> 48);
        this.writeBuffer[2] = (byte)(v >>> 40);
        this.writeBuffer[3] = (byte)(v >>> 32);
        this.writeBuffer[4] = (byte)(v >>> 24);
        this.writeBuffer[5] = (byte)(v >>> 16);
        this.writeBuffer[6] = (byte)(v >>> 8);
        this.writeBuffer[7] = (byte)(v >>> 0);
        this.write(this.writeBuffer, 0, 8);
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBytes(@NotNull String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    public void writeChars(@NotNull String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }
    }

    public void writeUTF(@NotNull String s) throws IOException {
        ChannelWriterOutputView.writeUTF(s, (DataOutput)((Object)this));
    }

    static int writeUTF(String str, DataOutput out) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        for (int i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
        }
        byte[] bytearr = null;
        if (out instanceof ChannelWriterOutputView) {
            ChannelWriterOutputView dos = (ChannelWriterOutputView)((Object)out);
            if (dos.bytearr == null || dos.bytearr.length < utflen + 2) {
                dos.bytearr = new byte[utflen * 2 + 2];
            }
            bytearr = dos.bytearr;
        } else {
            bytearr = new byte[utflen + 2];
        }
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        out.write(bytearr, 0, utflen + 2);
        return utflen + 2;
    }

    @Override
    public void close() throws IOException {
        IOException ioe = null;
        try {
            this.sendRequest();
        }
        catch (IOException ioException) {
            ioe = ioException;
        }
        try {
            this.writer.close();
        }
        catch (IOException ioException) {
            ioe = ioException;
        }
        try {
            this.fileChannel.close();
        }
        catch (IOException ioException) {
            ioe = ioException;
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    private static class SeekRequest
    implements WriterRequest {
        private final AsynchronousWriter writer;
        private final long position;
        private final CompletableFuture<Void> future;
        private final FileChannel fileChannel;

        public SeekRequest(AsynchronousWriter writer, long position, FileChannel fileChannel) {
            this.writer = writer;
            this.position = position;
            this.future = new CompletableFuture();
            this.fileChannel = fileChannel;
        }

        @Override
        public void write() throws IOException {
            this.fileChannel.position(this.position);
        }

        @Override
        public AsynchronousIOCallback getCallback() {
            return this.writer;
        }

        public CompletableFuture<Void> getFuture() {
            return this.future;
        }
    }

    private static class ByteWriterRequest
    implements WriterRequest {
        private final AsynchronousWriter writer;
        private final ByteBuffer buf;
        private final CompletableFuture<Void> future;
        private final FileChannel fileChannel;

        public ByteWriterRequest(ByteBuffer buf, AsynchronousWriter writer, FileChannel fileChannel) {
            this.buf = buf;
            this.writer = writer;
            this.future = new CompletableFuture();
            this.fileChannel = fileChannel;
        }

        @Override
        public void write() throws IOException {
            this.buf.flip();
            while (this.buf.hasRemaining()) {
                this.fileChannel.write(this.buf);
            }
        }

        @Override
        public AsynchronousIOCallback getCallback() {
            return this.writer;
        }

        public CompletableFuture<Void> getFuture() {
            return this.future;
        }
    }
}

