/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.algox.io;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import kd.bos.algo.RowMeta;
import kd.bos.flydb.core.interpreter.algox.io.AsynchronousReader;
import kd.bos.flydb.core.interpreter.algox.io.AsynchronousWriter;
import kd.bos.flydb.core.interpreter.algox.io.DataSetChannel;
import kd.bos.flydb.core.interpreter.algox.io.ReaderRequest;
import kd.bos.flydb.core.interpreter.algox.io.WriterRequest;

public class DataSetIOManager {
    private final File baseDir;
    private final WriterThread writerThread;
    private final ReaderThread readerThread;

    public DataSetIOManager(String basePath) {
        this(basePath, 32);
    }

    public DataSetIOManager(String basePath, int queueSize) {
        this.baseDir = new File(basePath, "flydb-dataset");
        if (!this.baseDir.exists()) {
            try {
                boolean result = this.baseDir.mkdirs();
                if (!result) {
                    throw new RuntimeException("Could not create dataset storage directory for DataSetIOManager: " + this.baseDir.getAbsolutePath());
                }
            }
            catch (SecurityException exception) {
                throw new RuntimeException("Could not create dataset storage directory for DataSetIOManager: " + this.baseDir.getAbsolutePath() + ", msg: " + exception.getMessage(), exception);
            }
        }
        this.writerThread = new WriterThread(queueSize);
        this.writerThread.setName("flydb-output-io-write");
        this.writerThread.setDaemon(true);
        this.writerThread.start();
        this.readerThread = new ReaderThread(queueSize);
        this.readerThread.setName("flydb-output-io-read");
        this.readerThread.setDaemon(true);
        this.readerThread.start();
    }

    public DataSetChannel createChannel(String id, RowMeta rowMeta) {
        return new DataSetChannel(this.baseDir, id, rowMeta);
    }

    public AsynchronousWriter createAsyncWriter() {
        return new AsynchronousWriter(this.writerThread.queue);
    }

    public AsynchronousReader createAsyncReader() {
        return new AsynchronousReader(this.readerThread.queue);
    }

    public String getBaseDir() {
        return this.baseDir.getAbsolutePath();
    }

    public static class WriterThread
    extends Thread {
        private final ArrayBlockingQueue<WriterRequest> queue;

        public WriterThread(int queueSize) {
            this.queue = new ArrayBlockingQueue(queueSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                IOException ioe = null;
                WriterRequest request = null;
                try {
                    request = this.queue.take();
                    request.write();
                    continue;
                }
                catch (InterruptedException e) {
                    ioe = new IOException("IO Writer thread has interrupted.", e);
                    return;
                }
                catch (IOException ioException) {
                    ioe = ioException;
                    continue;
                }
                finally {
                    if (request == null) continue;
                    if (ioe == null) {
                        request.getFuture().complete(null);
                    } else {
                        request.getFuture().completeExceptionally(ioe);
                    }
                    request.getCallback().done(request, ioe);
                    continue;
                }
                break;
            }
        }
    }

    public static class ReaderThread
    extends Thread {
        private final ArrayBlockingQueue<ReaderRequest> queue;

        public ReaderThread(int queueSize) {
            this.queue = new ArrayBlockingQueue(queueSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                IOException ioe = null;
                ReaderRequest request = null;
                try {
                    request = this.queue.take();
                    request.read();
                    continue;
                }
                catch (InterruptedException e) {
                    ioe = new IOException("IO Reader thread has interrupted.", e);
                    return;
                }
                catch (IOException ioException) {
                    ioe = ioException;
                    continue;
                }
                finally {
                    if (request == null) continue;
                    if (ioe == null) {
                        request.getFuture().complete(null);
                    } else {
                        request.getFuture().completeExceptionally(ioe);
                    }
                    request.getCallback().done(request, ioe);
                    continue;
                }
                break;
            }
        }
    }
}

