/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.algox.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import kd.bos.algo.RowMeta;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.interpreter.algox.RowSerializer;
import kd.bos.flydb.core.interpreter.algox.io.AsynchronousReader;
import kd.bos.flydb.core.interpreter.algox.io.AsynchronousWriter;
import kd.bos.flydb.core.interpreter.algox.io.ChannelReaderInputView;
import kd.bos.flydb.core.interpreter.algox.io.ChannelWriterOutputView;
import kd.bos.flydb.core.interpreter.algox.io.DataSetChannel;
import kd.bos.flydb.core.interpreter.algox.io.DataSetIOManager;
import org.apache.commons.io.FileUtils;

public class DataSetStorageManager {
    private static final int MAGIC_CODE = -4272888;
    private final DataSetIOManager ioManager;
    private final int batchCount;
    private final int readBufSize;
    private final int writeBufSize;

    public DataSetStorageManager(DataSetIOManager ioManager) {
        this(ioManager, 65536, 5000);
    }

    public DataSetStorageManager(DataSetIOManager ioManager, int bufSize, int batchCount) {
        this.ioManager = ioManager;
        this.readBufSize = bufSize;
        this.writeBufSize = bufSize;
        this.batchCount = batchCount;
    }

    public DataSetChannel createChannel(String id, RowMeta meta) {
        return this.ioManager.createChannel(id, meta);
    }

    public DataSetChannel getChannel(String id) throws IOException {
        DataSetChannel damaged = this.ioManager.createChannel(id, null);
        AsynchronousReader reader = this.ioManager.createAsyncReader();
        ChannelReaderInputView input = new ChannelReaderInputView(reader, this.readBufSize, damaged.getPath());
        int magicCode = input.readInt();
        if (magicCode != -4272888) {
            throw new IOException("The file has been damaged, magic code: 0x" + Integer.toHexString(magicCode) + ", path: " + damaged.getPath());
        }
        long count = input.readLong();
        long start = input.readLong();
        long end = input.readLong();
        int length = (int)(end - start);
        byte[] bytes = new byte[length];
        input.seek(start);
        input.readFully(bytes);
        ByteArrayInputStream metaByteArrayInputStream = new ByteArrayInputStream(bytes);
        ObjectInputStream metaInputStream = new ObjectInputStream(metaByteArrayInputStream);
        try {
            RowMeta rowMeta = (RowMeta)metaInputStream.readObject();
            metaInputStream.close();
            input.close();
            DataSetChannel channel = this.ioManager.createChannel(id, rowMeta);
            channel.setCount(count);
            return channel;
        }
        catch (Exception e) {
            throw new IOException("Read rowmeta data cause an exception, msg: " + e.getMessage() + " ,path=" + damaged.getPath() + ", start_offset=" + start + "end_offset=" + end, e);
        }
    }

    public void delete(String id) throws IOException {
        DataSetChannel channel = this.ioManager.createChannel(id, null);
        FileUtils.forceDelete((File)new File(channel.getPath()));
    }

    public void cleanExpired(int expiredOfHours) throws IOException {
        File baseDir;
        if (expiredOfHours <= 0) {
            expiredOfHours = 1;
        }
        if (!(baseDir = new File(this.ioManager.getBaseDir())).exists() && !baseDir.isDirectory()) {
            return;
        }
        ArrayList ioExceptions = new ArrayList();
        String fileSuffix = DataSetChannel.getSuffix();
        try (Stream<Path> paths = Files.list(baseDir.toPath());){
            int finalExpiredOfHours = expiredOfHours;
            paths.forEach(path -> {
                try {
                    LocalDateTime expiredTime;
                    if (!path.toFile().getAbsolutePath().endsWith(fileSuffix)) {
                        return;
                    }
                    BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                    LocalDateTime lastModifiedTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(attributes.lastModifiedTime().toMillis()), ZoneId.systemDefault());
                    if (lastModifiedTime.isAfter(expiredTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(System.currentTimeMillis()), ZoneId.systemDefault()).plusHours(-1 * finalExpiredOfHours))) {
                        return;
                    }
                    path.toFile().delete();
                }
                catch (IOException e) {
                    ioExceptions.add(e);
                }
            });
            if (!ioExceptions.isEmpty()) {
                throw (IOException)ioExceptions.get(0);
            }
        }
    }

    public Writer createWriter(DataSetChannel channel) throws IOException {
        RowSerializer serializer = new RowSerializer(channel.getRowMeta());
        AsynchronousWriter writer = this.ioManager.createAsyncWriter();
        ChannelWriterOutputView outputView = new ChannelWriterOutputView(writer, this.writeBufSize, channel.getPath());
        return new Writer(channel, serializer, outputView, this.batchCount);
    }

    public Reader createReader(DataSetChannel channel) throws IOException {
        RowSerializer serializer = new RowSerializer(channel.getRowMeta());
        AsynchronousReader reader = this.ioManager.createAsyncReader();
        ChannelReaderInputView inputView = new ChannelReaderInputView(reader, this.readBufSize, channel.getPath());
        return new Reader(channel, serializer, inputView);
    }

    public static class Writer
    implements AutoCloseable {
        private final RowMeta rowMeta;
        private final RowSerializer serializer;
        private final ChannelWriterOutputView output;
        private final int batchCount;
        private final List<Long> index;
        private long totalCount;

        public Writer(DataSetChannel channel, RowSerializer serializer, ChannelWriterOutputView output, int batchCount) throws IOException {
            this.rowMeta = channel.getRowMeta();
            this.serializer = serializer;
            this.output = output;
            this.batchCount = batchCount;
            this.index = new ArrayList<Long>(10000);
            this.begin();
        }

        private void begin() throws IOException {
            this.output.writeInt(0);
            this.output.writeLong(0L);
            this.output.writeLong(0L);
            this.output.writeLong(0L);
            this.index.add(28L);
        }

        public void write(Object[] data) throws IOException {
            this.serializer.serialize(data, this.output);
            ++this.totalCount;
            if (this.totalCount % (long)this.batchCount == 0L) {
                this.index.add(this.output.getPosition());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                long rowMetaOffset = this.output.getPosition();
                ByteArrayOutputStream bytes = new ByteArrayOutputStream(1024);
                ObjectOutputStream outputStream = new ObjectOutputStream(bytes);
                outputStream.writeObject(this.rowMeta);
                outputStream.flush();
                outputStream.close();
                this.output.write(bytes.toByteArray());
                bytes.close();
                long indexOffset = this.output.getPosition();
                this.output.writeInt(this.batchCount);
                this.output.writeInt(this.index.size());
                for (Long i : this.index) {
                    this.output.writeLong(i);
                }
                this.output.seek(4L);
                this.output.writeLong(this.totalCount);
                this.output.writeLong(rowMetaOffset);
                this.output.writeLong(indexOffset);
                this.output.seek(0L);
                this.output.writeInt(-4272888);
            }
            finally {
                this.output.close();
            }
        }
    }

    public static class ReaderIterator
    implements Iterator<Object[]> {
        private final Reader reader;
        private int limit;
        private int offset;
        private int cur = 0;

        public ReaderIterator(Reader reader, int limit, int offset) throws IOException {
            this.reader = reader;
            this.limit = limit;
            this.offset = offset;
            if (reader.totalCount == 0L || (long)offset >= reader.totalCount) {
                this.limit = 0;
            }
            if ((long)(offset + limit) > reader.totalCount) {
                this.limit = (int)(reader.totalCount - (long)offset);
            }
            if (this.limit < 0) {
                this.limit = 0;
            }
            this.begin();
        }

        private void begin() throws IOException {
            int idx = this.offset / this.reader.batchCount;
            int skip = this.offset % this.reader.batchCount;
            long position = (Long)this.reader.index.get(idx);
            this.reader.input.seek(position);
            for (int i = 0; i < skip; ++i) {
                this.reader.serializer.deserialize(this.reader.input);
            }
        }

        @Override
        public boolean hasNext() {
            return this.cur < this.limit;
        }

        @Override
        public Object[] next() {
            if (this.hasNext()) {
                ++this.cur;
                try {
                    return this.reader.serializer.deserialize(this.reader.input);
                }
                catch (IOException e) {
                    throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_ReadOutputFileError, (Object[])new Object[]{e.getMessage()});
                }
            }
            throw new NoSuchElementException();
        }
    }

    public static class Reader
    implements AutoCloseable {
        private final DataSetChannel channel;
        private final RowMeta rowMeta;
        private final RowSerializer serializer;
        private final ChannelReaderInputView input;
        private int batchCount;
        private List<Long> index;
        private long totalCount;

        public Reader(DataSetChannel channel, RowSerializer serializer, ChannelReaderInputView input) throws IOException {
            this.channel = channel;
            this.rowMeta = channel.getRowMeta();
            this.serializer = serializer;
            this.input = input;
            this.init();
        }

        private void init() throws IOException {
            int magicCode = this.input.readInt();
            if (magicCode != -4272888) {
                throw new IOException("The file has been damaged, magic code: 0x" + Integer.toHexString(magicCode) + ", path: " + this.channel.getPath());
            }
            this.totalCount = this.input.readLong();
            this.input.readLong();
            long indexOffset = this.input.readLong();
            this.input.seek(indexOffset);
            this.batchCount = this.input.readInt();
            int indexCount = this.input.readInt();
            this.index = new ArrayList<Long>(indexCount);
            for (int i = 0; i < indexCount; ++i) {
                this.index.add(this.input.readLong());
            }
            this.input.seek(28L);
        }

        public Iterator<Object[]> createReaderIterator(int limit, int offset) throws IOException {
            return new ReaderIterator(this, limit, offset);
        }

        public List<Object[]> read(int limit, int offset) throws IOException {
            Iterator<Object[]> iterator = this.createReaderIterator(limit, offset);
            ArrayList<Object[]> rows = new ArrayList<Object[]>(limit);
            while (iterator.hasNext()) {
                rows.add(iterator.next());
            }
            return rows;
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }
    }
}

