/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.bind;

import java.util.List;
import kd.bos.flydb.core.Context;
import kd.bos.flydb.core.interpreter.bind.BindableNode;
import kd.bos.flydb.core.rel.RelNode;
import kd.bos.flydb.core.rex.RexCall;
import kd.bos.flydb.core.rex.RexDynamicParam;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.rex.RexNodeList;
import kd.bos.flydb.core.rex.RexSubQuery;

public final class BindHelp {
    private BindHelp() {
    }

    public static BindableNode bind(BindableNode node, Context context) {
        BindableNode node2 = node.bind(context);
        if (node2.getInputList().size() > 0) {
            List<RelNode> inputList = node2.getInputList();
            for (int i = 0; i < inputList.size(); ++i) {
                BindableNode bind1 = (BindableNode)inputList.get(i);
                BindableNode bind2 = bind1.bind(context);
                if (bind2 != bind1) {
                    node2.replaceInput(i, bind2);
                }
                BindHelp.bind(bind2, context);
            }
        }
        return node2;
    }

    public static RexNode bind(RexNode node, Context context) {
        if (node instanceof RexCall) {
            RexCall call = node.cast(RexCall.class);
            for (int i = 0; i < call.getOperands().size(); ++i) {
                RexNode node1 = call.getOperand(i);
                RexNode node2 = BindHelp.bind(node1, context);
                if (node2 == node1) continue;
                call.replaceOperand(i, node2);
            }
            return call;
        }
        if (node instanceof RexNodeList) {
            RexNodeList list = node.cast(RexNodeList.class);
            for (int i = 0; i < list.size(); ++i) {
                RexNode node1 = list.get(i);
                RexNode node2 = BindHelp.bind(node1, context);
                if (node2 == node1) continue;
                list.set(i, node2);
            }
            return list;
        }
        if (node instanceof RexDynamicParam) {
            Context.Param param = context.getParam(node.cast(RexDynamicParam.class).getIndex());
            return param.toLiteral();
        }
        if (node instanceof RexSubQuery) {
            RexSubQuery query = node.cast(RexSubQuery.class);
            BindableNode subRelNode = BindHelp.bind((BindableNode)query.getQuery(), context);
            return new RexSubQuery(query.getOperator(), subRelNode, query.getType());
        }
        return node;
    }
}

