/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.bind;

import com.beust.jcommander.internal.Lists;
import java.util.Collections;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.Context;
import kd.bos.flydb.core.interpreter.bind.BindableNode;
import kd.bos.flydb.core.rel.Join;
import kd.bos.flydb.core.rel.RelNode;
import kd.bos.flydb.core.rel.TableScanTag;
import kd.bos.flydb.core.rex.RexCall;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.rex.RexNodeList;
import kd.bos.flydb.core.sql.operator.SqlOperators;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;

public class BindableDBDataSource
implements RelNode,
BindableNode {
    private final int tableScanTags = TableScanTag.create(TableScanTag.AGGREGATE, TableScanTag.JOIN, TableScanTag.FILTER, TableScanTag.ORDER_BY, TableScanTag.LIMIT, TableScanTag.OFFSET);
    private DataType dataType;
    private String id;
    private RexNodeList selectList;
    private RexNode filter;
    private RelNode from;
    private RexNodeList groupBy;
    private RexNode having;
    private RelNode aggregate;
    private RexNodeList orderBy;
    private RexNode limit;
    private RexNode offset;

    public BindableDBDataSource(DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public BindableNode bind(Context context) {
        return null;
    }

    private void checkTag(TableScanTag tag) {
        if (!TableScanTag.isAllow(this.tableScanTags, tag)) {
            throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedPushDown, (Object[])new Object[]{this.id, tag.name()});
        }
    }

    public boolean pushDownLimit(RexNode rexNode) {
        this.checkTag(TableScanTag.LIMIT);
        if (rexNode == null) {
            return false;
        }
        if (this.limit != null) {
            throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_RBOErrorRexHasExists, (Object[])new Object[]{TableScanTag.LIMIT.name()});
        }
        this.limit = rexNode;
        return true;
    }

    public boolean pushDownOffset(RexNode rexNode) {
        this.checkTag(TableScanTag.OFFSET);
        if (rexNode == null) {
            return false;
        }
        if (this.offset != null) {
            throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_RBOErrorRexHasExists, (Object[])new Object[]{TableScanTag.OFFSET.name()});
        }
        this.offset = rexNode;
        return true;
    }

    public boolean pushDownOrderBy(RexNodeList rexNodes) {
        this.checkTag(TableScanTag.ORDER_BY);
        if (rexNodes == null || rexNodes.isEmpty()) {
            return false;
        }
        if (this.orderBy != null) {
            throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_RBOErrorRexHasExists, (Object[])new Object[]{TableScanTag.ORDER_BY.name()});
        }
        this.orderBy = rexNodes;
        return true;
    }

    public boolean pushDownSelectList(RexNodeList rexNodes) {
        if (rexNodes == null || rexNodes.isEmpty()) {
            return false;
        }
        if (this.selectList != null) {
            throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_RBOErrorRexHasExists, (Object[])new Object[]{"SELECT_LIST"});
        }
        this.selectList = rexNodes;
        return true;
    }

    public boolean pushDownAggregate(RexNodeList groupBy, RexNode having, RelNode aggregate) {
        this.checkTag(TableScanTag.AGGREGATE);
        this.groupBy = groupBy;
        this.having = having;
        this.aggregate = aggregate;
        return true;
    }

    public boolean pushDownFilter(RexNode rexNode) {
        this.checkTag(TableScanTag.FILTER);
        if (rexNode == null) {
            return false;
        }
        this.filter = this.filter != null ? new RexCall(SqlOperators.of(SqlKind.AND), Lists.newArrayList((Object[])new RexNode[]{this.filter, rexNode}), DataTypeFactory.instance.buildBoolean()) : rexNode;
        return true;
    }

    public boolean pushDownFrom(RelNode relNode) {
        if (relNode == null) {
            return false;
        }
        if (this.from != null) {
            throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_RBOErrorRexHasExists, (Object[])new Object[]{"Relation"});
        }
        if (relNode instanceof Join) {
            this.checkTag(TableScanTag.JOIN);
        }
        this.from = relNode;
        return true;
    }

    @Override
    public DataType getRowType() {
        return this.dataType;
    }

    @Override
    public RelNode getInput(int i) {
        throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
    }

    @Override
    public List<RelNode> getInputList() {
        return Collections.emptyList();
    }

    @Override
    public void replaceInput(int i, RelNode input) {
        throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
    }
}

