/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.EvaluationUtil;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;

public class Add
extends BaseScalarEvaluation {
    private static final long serialVersionUID = -2441204089778201197L;
    private ScalarEvaluation left;
    private ScalarEvaluation right;

    public Add(ScalarEvaluation left, ScalarEvaluation right) {
        this.left = left;
        this.right = right;
        this.type = TYPECOERCION.higherPrecision4NumberType(left.getType(), right.getType());
    }

    @Override
    public Object eval(Object[] inputs) {
        Object leftValue = this.left.eval(inputs);
        Object rightValue = this.right.eval(inputs);
        if (leftValue == null || rightValue == null) {
            return null;
        }
        BigDecimal l = EvaluationUtil.toBigDecimal(this.left.getType(), leftValue);
        BigDecimal r = EvaluationUtil.toBigDecimal(this.right.getType(), rightValue);
        return EvaluationUtil.convertResult(this.type, l.add(r));
    }

    @Override
    protected List<ScalarEvaluation> getChild() {
        return Lists.newArrayList((Object[])new ScalarEvaluation[]{this.left, this.right});
    }
}

