/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import java.util.List;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.sql.tree.SqlCaseWhenType;

public class CaseWhen
extends BaseScalarEvaluation {
    private SqlCaseWhenType caseWhenType;
    private ScalarEvaluation valueEvaluation;
    private List<ScalarEvaluation> whenEvaluations;
    private List<ScalarEvaluation> thenEvaluations;
    private ScalarEvaluation elseEvaluation;

    public CaseWhen(SqlCaseWhenType caseWhenType, ScalarEvaluation valueEvaluation, List<ScalarEvaluation> whenEvaluations, List<ScalarEvaluation> thenEvaluations, ScalarEvaluation elseEvaluation) {
        this.caseWhenType = caseWhenType;
        this.valueEvaluation = valueEvaluation;
        this.whenEvaluations = whenEvaluations;
        this.thenEvaluations = thenEvaluations;
        this.elseEvaluation = elseEvaluation;
        this.type = thenEvaluations.get(0).getType();
    }

    @Override
    public Object eval(Object[] inputs) {
        if (SqlCaseWhenType.SimpleCase == this.caseWhenType) {
            return this.simpleCaseWhenEval(inputs);
        }
        return this.searchedCaseWhenEval(inputs);
    }

    private Object simpleCaseWhenEval(Object[] inputs) {
        Object caseWhenValue = this.valueEvaluation.eval(inputs);
        int thenIndex = -1;
        for (int i = 0; i < this.whenEvaluations.size(); ++i) {
            Object whenValue = this.whenEvaluations.get(i).eval(inputs);
            if (whenValue == null || !whenValue.equals(caseWhenValue)) continue;
            thenIndex = i;
            break;
        }
        Object result = thenIndex >= 0 ? this.thenEvaluations.get(thenIndex).eval(inputs) : this.elseEvaluation.eval(inputs);
        return result;
    }

    private Object searchedCaseWhenEval(Object[] inputs) {
        int thenIndex = -1;
        for (int i = 0; i < this.whenEvaluations.size(); ++i) {
            Object whenValue = this.whenEvaluations.get(i).eval(inputs);
            if (!(whenValue instanceof Boolean) || !((Boolean)whenValue).booleanValue()) continue;
            thenIndex = i;
            break;
        }
        Object result = thenIndex >= 0 ? this.thenEvaluations.get(thenIndex).eval(inputs) : this.elseEvaluation.eval(inputs);
        return result;
    }
}

