/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.interpreter.algox.DataSetOutputManager;
import kd.bos.flydb.core.interpreter.algox.DataSetOutputManagers;
import kd.bos.flydb.core.interpreter.algox.DataSetReader;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.sql.type.DataType;

public class DataSetLiteral
extends BaseScalarEvaluation {
    private final String cursorId;

    public DataSetLiteral(String cursorId, DataType dataType) {
        this.cursorId = cursorId;
        this.type = dataType;
    }

    @Override
    public Object eval(Object[] inputs) {
        DataSetOutputManager manager = DataSetOutputManagers.get();
        try (DataSetReader reader = manager.createReader(this.cursorId);){
            long count = reader.getCount();
            if (count > Integer.MAX_VALUE) {
                throw Exceptions.of((ErrorCode)ErrorCode.SubQueryDataCountOverflow, (Object[])new Object[]{Integer.MAX_VALUE});
            }
            List<Object> list = reader.read((int)count, 0, 0);
            return list;
        }
    }
}

