/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.SqlTypeName;

public class EvaluationUtil {
    public static BigDecimal toBigDecimal(DataType dataType, Object value) {
        if (dataType.getTypeName() == SqlTypeName.INT) {
            return new BigDecimal((Integer)value);
        }
        if (dataType.getTypeName() == SqlTypeName.LONG) {
            return new BigDecimal((Long)value);
        }
        return (BigDecimal)value;
    }

    public static Object convertResult(DataType dataType, BigDecimal result) {
        if (dataType.getTypeName() == SqlTypeName.INT) {
            return result.intValue();
        }
        if (dataType.getTypeName() == SqlTypeName.LONG) {
            return result.longValue();
        }
        return result;
    }

    public static boolean equal(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a instanceof Number && b instanceof Number) {
            return EvaluationUtil.compareNumber((Number)a, (Number)b) == 0;
        }
        if (a instanceof Comparable && b instanceof Comparable) {
            return ((Comparable)a).compareTo(b) == 0;
        }
        return a.equals(b);
    }

    public static int _compareDate(Object d1, Object d2, SqlTypeName typeName) {
        if (typeName == SqlTypeName.DATE) {
            return EvaluationUtil.compareDate(d1, d2);
        }
        if (typeName == SqlTypeName.TIME) {
            return EvaluationUtil.compareTime(d1, d2);
        }
        if (typeName == SqlTypeName.DATETIME) {
            return EvaluationUtil.compareTimestamp(d1, d2);
        }
        throw Exceptions.of((ErrorCode)ErrorCode.UnexpectedComparisonDateValue, (Object[])new Object[]{d1.getClass(), d2.getClass()});
    }

    public static int compareDate(Object d1, Object d2) {
        LocalDate right;
        LocalDate left;
        if (EvaluationUtil.compareWithNull(d1, d2)) {
            return EvaluationUtil.compareNull(d1, d2);
        }
        if (d1 instanceof Date) {
            left = ((Date)d1).toLocalDate();
        } else if (d1 instanceof Timestamp) {
            left = ((Timestamp)d1).toLocalDateTime().toLocalDate();
        } else if (d1.getClass().equals(java.util.Date.class)) {
            left = ((java.util.Date)d1).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        } else if (d1 instanceof LocalDate) {
            left = (LocalDate)d1;
        } else if (d1 instanceof LocalDateTime) {
            left = ((LocalDateTime)d1).toLocalDate();
        } else {
            throw Exceptions.of((ErrorCode)ErrorCode.UnexpectedComparisonDateValue, (Object[])new Object[]{d1.getClass(), d2.getClass()});
        }
        if (d2 instanceof Date) {
            right = ((Date)d2).toLocalDate();
        } else if (d2 instanceof Timestamp) {
            right = ((Timestamp)d2).toLocalDateTime().toLocalDate();
        } else if (d2.getClass().equals(java.util.Date.class)) {
            right = ((java.util.Date)d2).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        } else if (d2 instanceof LocalDate) {
            right = (LocalDate)d2;
        } else if (d2 instanceof LocalDateTime) {
            right = ((LocalDateTime)d2).toLocalDate();
        } else {
            throw Exceptions.of((ErrorCode)ErrorCode.UnexpectedComparisonDateValue, (Object[])new Object[]{d1.getClass(), d2.getClass()});
        }
        return left.compareTo(right);
    }

    public static int compareTime(Object left, Object right) {
        LocalTime r;
        LocalTime l;
        if (EvaluationUtil.compareWithNull(left, right)) {
            return EvaluationUtil.compareNull(left, right);
        }
        if (left instanceof Time) {
            l = ((Time)left).toLocalTime();
        } else if (left.getClass().equals(java.util.Date.class)) {
            l = ((java.util.Date)left).toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
        } else if (left instanceof LocalTime) {
            l = (LocalTime)left;
        } else {
            throw Exceptions.of((ErrorCode)ErrorCode.UnexpectedComparisonDateValue, (Object[])new Object[]{left.getClass(), right.getClass()});
        }
        if (right instanceof Time) {
            r = ((Time)right).toLocalTime();
        } else if (right.getClass().equals(java.util.Date.class)) {
            r = ((java.util.Date)right).toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
        } else if (right instanceof LocalTime) {
            r = (LocalTime)right;
        } else {
            throw Exceptions.of((ErrorCode)ErrorCode.UnexpectedComparisonDateValue, (Object[])new Object[]{left.getClass(), right.getClass()});
        }
        return l.compareTo(r);
    }

    public static int compareTimestamp(Object left, Object right) {
        LocalDateTime r;
        LocalDateTime l;
        if (EvaluationUtil.compareWithNull(left, right)) {
            return EvaluationUtil.compareNull(left, right);
        }
        if (left instanceof Timestamp) {
            l = ((Timestamp)left).toLocalDateTime();
        } else if (left.getClass().equals(java.util.Date.class)) {
            l = ((java.util.Date)left).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        } else if (left instanceof LocalDateTime) {
            l = (LocalDateTime)left;
        } else if (left instanceof Date) {
            l = ((Date)left).toLocalDate().atStartOfDay();
        } else if (left instanceof LocalDate) {
            l = ((LocalDate)left).atStartOfDay();
        } else {
            throw Exceptions.of((ErrorCode)ErrorCode.UnexpectedComparisonDateValue, (Object[])new Object[]{left.getClass(), right.getClass()});
        }
        if (right instanceof Timestamp) {
            r = ((Timestamp)right).toLocalDateTime();
        } else if (right.getClass().equals(java.util.Date.class)) {
            r = ((java.util.Date)right).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        } else if (right instanceof LocalDateTime) {
            r = (LocalDateTime)right;
        } else if (right instanceof Date) {
            r = ((Date)right).toLocalDate().atStartOfDay();
        } else if (right instanceof LocalDate) {
            r = ((LocalDate)right).atStartOfDay();
        } else {
            throw Exceptions.of((ErrorCode)ErrorCode.UnexpectedComparisonDateValue, (Object[])new Object[]{left.getClass(), right.getClass()});
        }
        return l.compareTo(r);
    }

    public static int compareBoolean(Boolean b1, Boolean b2) {
        if (b1.booleanValue()) {
            return b2 != false ? 0 : 1;
        }
        return b2 != false ? -1 : 0;
    }

    public static int compareNull(Object left, Object right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        return 1;
    }

    public static boolean compareWithNull(Object left, Object right) {
        return left == null || right == null;
    }

    public static int compareNumber(Number n1, Number n2) {
        if (EvaluationUtil.compareWithNull(n1, n2)) {
            return EvaluationUtil.compareNull(n1, n2);
        }
        if (n1.getClass() == n2.getClass()) {
            return ((Comparable)((Object)n1)).compareTo(n2);
        }
        return EvaluationUtil.compareNumber0(n1, n2);
    }

    private static int compareNumber0(Number n1, Number n2) {
        if (n1 instanceof BigDecimal || n2 instanceof BigDecimal) {
            return EvaluationUtil.toBigDecimal(n1).compareTo(EvaluationUtil.toBigDecimal(n2));
        }
        if (n1 instanceof Double || n2 instanceof Double || n1 instanceof Float || n2 instanceof Float) {
            return EvaluationUtil.toBigDecimal(n1).compareTo(EvaluationUtil.toBigDecimal(n2));
        }
        if (n1 instanceof Long || n2 instanceof Long) {
            return Long.compare(n1.longValue(), n2.longValue());
        }
        if (n1 instanceof Integer || n2 instanceof Integer) {
            return Integer.compare(n1.intValue(), n2.intValue());
        }
        if (n1 instanceof Short || n2 instanceof Short) {
            return Short.compare(n1.shortValue(), n2.shortValue());
        }
        if (n1 instanceof Byte || n2 instanceof Byte) {
            return Byte.compare(n1.byteValue(), n2.byteValue());
        }
        throw Exceptions.of((ErrorCode)ErrorCode.UnexpectedComparisonNumberValue, (Object[])new Object[]{n1.getClass(), n2.getClass()});
    }

    public static final BigDecimal toBigDecimal(Number n) {
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        if (n instanceof Long) {
            return BigDecimal.valueOf(n.longValue());
        }
        if (n instanceof Integer) {
            return BigDecimal.valueOf(n.intValue());
        }
        if (n instanceof Double) {
            return BigDecimal.valueOf(n.doubleValue());
        }
        return new BigDecimal(String.valueOf(n));
    }
}

