/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.util.AlgoUtil;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.sql.type.DataTypeFactory;

public class InListOrNot
extends BaseScalarEvaluation {
    private static final long serialVersionUID = 3549652179594357258L;
    private final ScalarEvaluation leftEvaluation;
    private final List<ScalarEvaluation> rightEvaluation;
    private final boolean isInType;
    private HashSet<Object> set;
    private InKey cacheKey = new InKey(1);

    public InListOrNot(ScalarEvaluation leftEvaluation, List<ScalarEvaluation> rightEvaluation, boolean isInType) {
        this.leftEvaluation = leftEvaluation;
        this.rightEvaluation = rightEvaluation;
        this.isInType = isInType;
        this.type = DataTypeFactory.instance.buildBoolean();
    }

    @Override
    public Object eval(Object[] inputs) {
        Object lEval = this.leftEvaluation.eval(inputs);
        if (lEval == null) {
            return !this.isInType;
        }
        if (this.set == null) {
            this.buildSet(inputs);
        }
        return this.isInType == this.set.contains(this.wrapKey(lEval));
    }

    private Object wrapKey(Object value) {
        this.cacheKey.setValue(value);
        return this.cacheKey;
    }

    private void buildSet(Object[] inputs) {
        this.set = new HashSet();
        for (int i = 0; i < this.rightEvaluation.size(); ++i) {
            Object v = this.rightEvaluation.get(i).eval(inputs);
            if (v == null) continue;
            if (v instanceof Collection) {
                for (Object child : (Collection)v) {
                    if (child == null) continue;
                    this.set.add(this.makeKey(child));
                }
                continue;
            }
            if (v.getClass().isArray()) {
                int len = Array.getLength(v);
                for (int ii = 0; ii < len; ++ii) {
                    Object child = Array.get(v, ii);
                    if (child == null) continue;
                    this.set.add(this.makeKey(child));
                }
                continue;
            }
            this.set.add(this.makeKey(v));
        }
    }

    private Object makeKey(Object value) {
        return new InKey(value);
    }

    @Override
    protected List<ScalarEvaluation> getChild() {
        ArrayList list = Lists.newArrayList((Object[])new ScalarEvaluation[]{this.leftEvaluation});
        list.addAll(this.rightEvaluation);
        return list;
    }

    private static class InKey
    implements Serializable {
        private static final long serialVersionUID = -4075239542182156994L;
        private Object value;
        private int hashCode;

        InKey(Object value) {
            this.setValue(value);
        }

        private void setValue(Object value) {
            if (value instanceof Number) {
                this.value = AlgoUtil.toBigDecimal((Object)value);
                this.hashCode = ((BigDecimal)this.value).intValue();
            } else {
                this.value = value;
                this.hashCode = value.hashCode();
            }
        }

        public boolean equals(Object x) {
            return x != null && AlgoUtil.equal((Object)this.value, (Object)((InKey)x).value);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

