/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import java.util.Arrays;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.type.SqlTypeCategory;

public class LikeOrNot
extends BaseScalarEvaluation {
    private static final long serialVersionUID = 6872011239669070660L;
    private final ScalarEvaluation leftEvaluation;
    private final ScalarEvaluation rightEvaluation;
    private final boolean isLikeType;

    public LikeOrNot(ScalarEvaluation leftEvaluation, ScalarEvaluation rightEvaluation, boolean isLikeType) {
        this.leftEvaluation = leftEvaluation;
        this.rightEvaluation = rightEvaluation;
        this.isLikeType = isLikeType;
        this.type = DataTypeFactory.instance.buildBoolean();
    }

    @Override
    public Object eval(Object[] inputs) {
        DataType leftType = this.leftEvaluation.getType();
        DataType rightType = this.rightEvaluation.getType();
        Object lEval = this.leftEvaluation.eval(inputs);
        Object rEval = this.rightEvaluation.eval(inputs);
        if (lEval == null) {
            return !this.isLikeType;
        }
        if (rEval == null) {
            throw Exceptions.of((ErrorCode)ErrorCode.LikePatternNull, (Object[])new Object[0]);
        }
        if (leftType.getCategory() != SqlTypeCategory.STRING) {
            throw Exceptions.of((ErrorCode)ErrorCode.LikePatternRequireStringType, (Object[])new Object[]{leftType.getTypeName().name()});
        }
        if (rightType.getCategory() != SqlTypeCategory.STRING) {
            throw Exceptions.of((ErrorCode)ErrorCode.LikePatternRequireStringType, (Object[])new Object[]{rightType.getTypeName().name()});
        }
        String pattern = rEval.toString().trim();
        boolean leftLike = false;
        boolean rightLike = false;
        if (pattern.startsWith("%")) {
            leftLike = true;
            pattern = pattern.substring(1);
        }
        if (pattern.endsWith("%")) {
            rightLike = true;
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        if (leftLike && rightLike) {
            return this.isLikeType == lEval.toString().contains(pattern);
        }
        if (leftLike) {
            return this.isLikeType == lEval.toString().endsWith(pattern);
        }
        if (rightLike) {
            return this.isLikeType == lEval.toString().startsWith(pattern);
        }
        return this.isLikeType == lEval.equals(pattern);
    }

    @Override
    protected List<ScalarEvaluation> getChild() {
        return Arrays.asList(this.leftEvaluation, this.rightEvaluation);
    }
}

