/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.EvaluationUtil;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.sql.type.SqlTypeName;

public class Mod
extends BaseScalarEvaluation {
    private static final long serialVersionUID = 5947564064734144144L;
    private ScalarEvaluation left;
    private ScalarEvaluation right;

    public Mod(ScalarEvaluation left, ScalarEvaluation right) {
        this.left = left;
        this.right = right;
        this.type = TYPECOERCION.higherPrecision4NumberType(left.getType(), right.getType());
    }

    @Override
    public Object eval(Object[] inputs) {
        Object leftValue = this.left.eval(inputs);
        Object rightValue = this.right.eval(inputs);
        if (leftValue == null || rightValue == null) {
            return null;
        }
        if (this.left.getType().getTypeName() == SqlTypeName.STRING || this.right.getType().getTypeName() == SqlTypeName.STRING) {
            return null;
        }
        BigDecimal l = EvaluationUtil.toBigDecimal(this.left.getType(), leftValue);
        BigDecimal r = EvaluationUtil.toBigDecimal(this.right.getType(), rightValue);
        if (r.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return EvaluationUtil.convertResult(this.type, l.remainder(r));
    }

    @Override
    protected List<ScalarEvaluation> getChild() {
        return Lists.newArrayList((Object[])new ScalarEvaluation[]{this.left, this.right});
    }
}

