/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import java.util.Arrays;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.sql.type.SqlTypeCategory;

public class SubString
extends BaseScalarEvaluation {
    private static final long serialVersionUID = 3617005693549829154L;
    private List<ScalarEvaluation> evaluationList;

    public SubString(ScalarEvaluation ... evaluations) {
        this.evaluationList = Arrays.asList(evaluations);
        if (this.evaluationList.size() != 3) {
            throw Exceptions.of((ErrorCode)ErrorCode.FunctionRequireArgument, (Object[])new Object[]{"SUBSTRING", "3"});
        }
        this.type = evaluations[0].getType();
    }

    @Override
    public Object eval(Object[] inputs) {
        Object eval = this.evaluationList.get(0).eval(inputs);
        if (eval == null) {
            return null;
        }
        if (eval instanceof String) {
            ScalarEvaluation fromEval = this.evaluationList.get(1);
            ScalarEvaluation countEval = this.evaluationList.get(2);
            if (fromEval.getType().getCategory() != SqlTypeCategory.NUMBER || countEval.getType().getCategory() != SqlTypeCategory.NUMBER) {
                throw Exceptions.of((ErrorCode)ErrorCode.SubStringRequireNumberArgument, (Object[])new Object[0]);
            }
            int length = ((String)eval).length();
            int from = ((Number)fromEval.eval(inputs)).intValue();
            int count = ((Number)countEval.eval(inputs)).intValue();
            if (length == 0 || count == 0) {
                return "";
            }
            if (count < 0) {
                throw Exceptions.of((ErrorCode)ErrorCode.NegativeSubstringLength, (Object[])new Object[0]);
            }
            if (from <= 0) {
                from = 1;
            }
            if (from > length) {
                return "";
            }
            if (--from + count > length) {
                return ((String)eval).substring(from, length);
            }
            return ((String)eval).substring(from, from + count);
        }
        throw Exceptions.of((ErrorCode)ErrorCode.SubStringRequireStringArgument, (Object[])new Object[0]);
    }
}

