/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.sql.type.DataTypeFactory;

public class SubWeeks
extends BaseScalarEvaluation {
    private static final long serialVersionUID = 5333433746657891611L;
    private ScalarEvaluation left;
    private ScalarEvaluation right;

    public SubWeeks(ScalarEvaluation left, ScalarEvaluation right) {
        this.left = left;
        this.right = right;
        this.type = DataTypeFactory.instance.buildDate();
    }

    @Override
    public Object eval(Object[] inputs) {
        Object leftValue = this.left.eval(inputs);
        Object rightValue = this.right.eval(inputs);
        if (leftValue == null) {
            return null;
        }
        if (rightValue == null) {
            return leftValue;
        }
        if (leftValue instanceof java.sql.Date) {
            LocalDate date = ((java.sql.Date)leftValue).toLocalDate().minusWeeks(Long.parseLong(rightValue.toString()));
            return java.sql.Date.valueOf(date);
        }
        if (leftValue instanceof Timestamp) {
            LocalDate date = ((Timestamp)leftValue).toLocalDateTime().toLocalDate().minusWeeks(Long.parseLong(rightValue.toString()));
            return java.sql.Date.valueOf(date);
        }
        if (leftValue instanceof Date) {
            LocalDate date = ((Date)leftValue).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().minusWeeks(Long.parseLong(rightValue.toString()));
            return java.sql.Date.valueOf(date);
        }
        if (leftValue instanceof LocalDate) {
            return java.sql.Date.valueOf(((LocalDate)leftValue).minusWeeks(Long.parseLong(rightValue.toString())));
        }
        if (leftValue instanceof LocalDateTime) {
            LocalDate date = ((LocalDateTime)leftValue).toLocalDate().minusWeeks(Long.parseLong(rightValue.toString()));
            return java.sql.Date.valueOf(date);
        }
        throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedDateType, (Object[])new Object[]{leftValue.getClass(), "SUB_WEEKS"});
    }

    @Override
    protected List<ScalarEvaluation> getChild() {
        return Lists.newArrayList((Object[])new ScalarEvaluation[]{this.left, this.right});
    }
}

