/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import com.google.common.collect.Lists;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.sql.type.DataTypeFactory;

public class ToDate
extends BaseScalarEvaluation {
    private static final long serialVersionUID = 3825568193718067369L;
    private ScalarEvaluation child;

    public ToDate(ScalarEvaluation child) {
        this.child = child;
        this.type = DataTypeFactory.instance.buildDate();
    }

    @Override
    public Object eval(Object[] inputs) {
        Object date = this.child.eval(inputs);
        if (date == null) {
            return null;
        }
        if (date instanceof CharSequence) {
            try {
                return Date.valueOf(LocalDate.parse((CharSequence)date, DATE_FORMATTER));
            }
            catch (Exception e) {
                throw Exceptions.of((ErrorCode)ErrorCode.CastError, (Object[])new Object[]{date, this.type.getTypeName()});
            }
        }
        throw Exceptions.of((ErrorCode)ErrorCode.CastError1, (Object[])new Object[]{date.getClass(), this.type.getTypeName()});
    }

    @Override
    protected List<ScalarEvaluation> getChild() {
        return Lists.newArrayList((Object[])new ScalarEvaluation[]{this.child});
    }
}

