/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.sql.type.DataTypeFactory;

public class ToDatetime
extends BaseScalarEvaluation {
    private static final long serialVersionUID = 1209392511449406925L;
    private ScalarEvaluation child;

    public ToDatetime(ScalarEvaluation child) {
        this.child = child;
        this.type = DataTypeFactory.instance.buildDatetime();
    }

    @Override
    public Object eval(Object[] inputs) {
        Object dateTime = this.child.eval(inputs);
        if (dateTime == null) {
            return null;
        }
        if (dateTime instanceof CharSequence) {
            try {
                return Timestamp.valueOf(LocalDateTime.parse((CharSequence)dateTime, DATETIME_FORMATTER));
            }
            catch (Exception e) {
                throw Exceptions.of((ErrorCode)ErrorCode.CastError, (Object[])new Object[]{dateTime, this.type.getTypeName()});
            }
        }
        throw Exceptions.of((ErrorCode)ErrorCode.CastError1, (Object[])new Object[]{dateTime.getClass(), this.type.getTypeName()});
    }

    @Override
    protected List<ScalarEvaluation> getChild() {
        return Lists.newArrayList((Object[])new ScalarEvaluation[]{this.child});
    }
}

