/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import com.google.common.collect.Lists;
import java.sql.Time;
import java.time.LocalTime;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.sql.type.DataTypeFactory;

public class ToTime
extends BaseScalarEvaluation {
    private static final long serialVersionUID = -6692586991117974320L;
    private ScalarEvaluation child;

    public ToTime(ScalarEvaluation child) {
        this.child = child;
        this.type = DataTypeFactory.instance.buildTime();
    }

    @Override
    public Object eval(Object[] inputs) {
        Object time = this.child.eval(inputs);
        if (time == null) {
            return null;
        }
        if (time instanceof CharSequence) {
            try {
                return Time.valueOf(LocalTime.parse((CharSequence)time, TIME_FORMATTER));
            }
            catch (Exception e) {
                throw Exceptions.of((ErrorCode)ErrorCode.CastError, (Object[])new Object[]{time, this.type.getTypeName()});
            }
        }
        throw Exceptions.of((ErrorCode)ErrorCode.CastError1, (Object[])new Object[]{time.getClass(), this.type.getTypeName()});
    }

    @Override
    protected List<ScalarEvaluation> getChild() {
        return Lists.newArrayList((Object[])new ScalarEvaluation[]{this.child});
    }
}

