/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import java.math.BigDecimal;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.Context;
import kd.bos.flydb.core.interpreter.scalar.EvaluationUtil;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.SqlTypeCategory;

public class Unary
implements ScalarEvaluation {
    private String operator;
    private ScalarEvaluation operand;

    public Unary(String operator, ScalarEvaluation operand) {
        this.operator = operator;
        this.operand = operand;
    }

    @Override
    public Object eval(Object[] inputs) {
        Object value = this.operand.eval(inputs);
        if (this.operator.equalsIgnoreCase("+")) {
            return value;
        }
        if (this.operand.getType().getCategory() == SqlTypeCategory.NUMBER) {
            BigDecimal v = EvaluationUtil.toBigDecimal(this.operand.getType(), value);
            v = v.multiply(new BigDecimal(-1));
            return EvaluationUtil.convertResult(this.operand.getType(), v);
        }
        throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireNumberArgumentType, (Object[])new Object[]{"Unary"});
    }

    @Override
    public DataType getType() {
        return this.operand.getType();
    }

    @Override
    public void setContext(Context context) {
        this.operand.setContext(context);
    }
}

