/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.sql.type.DataTypeFactory;

public class XOR
extends BaseScalarEvaluation {
    private static final long serialVersionUID = -6336252688126360066L;
    private ScalarEvaluation left;
    private ScalarEvaluation right;

    public XOR(ScalarEvaluation left, ScalarEvaluation right) {
        this.left = left;
        this.right = right;
        this.type = DataTypeFactory.instance.buildBoolean();
    }

    @Override
    public Object eval(Object[] inputs) {
        Object leftValue = this.left.eval(inputs);
        Object rightValue = this.right.eval(inputs);
        if (leftValue == null || rightValue == null) {
            return null;
        }
        if (((Boolean)leftValue).booleanValue()) {
            return (Boolean)rightValue == false;
        }
        return rightValue;
    }

    @Override
    protected List<ScalarEvaluation> getChild() {
        return Lists.newArrayList((Object[])new ScalarEvaluation[]{this.left, this.right});
    }
}

