/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.optimize.rbo;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.optimize.rbo.PredictPushDownRule;
import kd.bos.flydb.core.optimize.rbo.Rule;
import kd.bos.flydb.core.optimize.rbo.TableScan2DataSourceRule;
import kd.bos.flydb.core.rel.RelNode;
import kd.bos.flydb.core.util.DirectedGraph;

public class Planner {
    private static final List<Rule> rules = new ArrayList<Rule>();
    private DirectedGraph.Vertex<RelNode> root;
    private final DirectedGraph<RelNode> graph;

    public Planner(RelNode relNode) {
        this.root = new DirectedGraph.Vertex<RelNode>(relNode);
        this.graph = new DirectedGraph();
        this.buildGraph(this.root, relNode);
    }

    private void buildGraph(DirectedGraph.Vertex<RelNode> source, RelNode current) {
        for (RelNode input : current.getInputList()) {
            DirectedGraph.Vertex<RelNode> target = new DirectedGraph.Vertex<RelNode>(input);
            this.graph.addVertex(target);
            this.graph.addEdge(source, target);
            this.buildGraph(target, input);
        }
    }

    public void setRoot(DirectedGraph.Vertex<RelNode> root) {
        this.root = root;
    }

    public RelNode getRoot() {
        this.rebuild(this.root);
        return this.root.getNode();
    }

    private void rebuild(DirectedGraph.Vertex<RelNode> r) {
        ImmutableList<DirectedGraph.Edge<RelNode>> outList = this.graph.getOutEdgeList(r);
        if (outList == null || outList.isEmpty()) {
            return;
        }
        RelNode node = r.getNode();
        for (int i = 0; i < outList.size(); ++i) {
            node.replaceInput(i, (RelNode)((DirectedGraph.Edge)outList.get(i)).getTarget().getNode());
            this.rebuild(((DirectedGraph.Edge)outList.get(i)).getTarget());
        }
    }

    private boolean matchAndApply(Rule rule, List<DirectedGraph.Vertex<RelNode>> path) {
        ImmutableList<Class<?>> template = rule.getMatchTemplate();
        if (path.size() < template.size()) {
            return false;
        }
        block0: for (int p = 0; p < path.size(); ++p) {
            for (int t = 0; t < template.size(); ++t) {
                DirectedGraph.Vertex<RelNode> result;
                DirectedGraph.Vertex<RelNode> matched;
                if (template.size() > path.size() - p) {
                    return false;
                }
                if (!((Class)template.get(t)).isInstance(path.get(p + t).getNode())) continue block0;
                if (t != template.size() - 1 || !rule.isAccept(matched = path.get(p)) || (result = rule.apply(matched, this.graph, path.subList(p, path.size()))) == path.get(p)) continue;
                ImmutableList<DirectedGraph.Edge<RelNode>> ins = this.graph.getInEdgeList(matched);
                if (ins != null && !ins.isEmpty()) {
                    for (DirectedGraph.Edge in : ins) {
                        this.graph.addEdge(in.getSource(), result);
                        this.graph.remove(in.getSource(), matched);
                    }
                }
                if (matched == this.root) {
                    this.root = result;
                }
                return true;
            }
        }
        return false;
    }

    private List<DirectedGraph.Vertex<RelNode>> findLeafs() {
        ImmutableSet<DirectedGraph.Vertex<RelNode>> allVertices = this.graph.getAllVertices();
        ArrayList<DirectedGraph.Vertex<RelNode>> leafVertexList = new ArrayList<DirectedGraph.Vertex<RelNode>>();
        for (DirectedGraph.Vertex vertex : allVertices) {
            ImmutableList<DirectedGraph.Edge<RelNode>> inList = this.graph.getInEdgeList(vertex);
            ImmutableList<DirectedGraph.Edge<RelNode>> outList = this.graph.getOutEdgeList(vertex);
            if (outList != null && !outList.isEmpty() || inList == null || inList.isEmpty()) continue;
            leafVertexList.add(vertex);
        }
        return leafVertexList;
    }

    private List<DirectedGraph.Vertex<RelNode>> findPath(DirectedGraph.Vertex<RelNode> leaf) {
        ArrayList<DirectedGraph.Vertex<RelNode>> path = new ArrayList<DirectedGraph.Vertex<RelNode>>();
        path.add(leaf);
        ImmutableList<DirectedGraph.Edge<RelNode>> inList = this.graph.getInEdgeList(leaf);
        while (inList != null && !inList.isEmpty()) {
            if (inList.size() > 1) {
                throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_PlannerBuildError, (Object[])new Object[0]);
            }
            DirectedGraph.Vertex source = ((DirectedGraph.Edge)inList.get(0)).getSource();
            path.add(0, source);
            inList = this.graph.getInEdgeList(source);
        }
        return path;
    }

    private boolean applyRule(Rule rule) {
        List<DirectedGraph.Vertex<RelNode>> leafs = this.findLeafs();
        for (DirectedGraph.Vertex<RelNode> leaf : leafs) {
            List<DirectedGraph.Vertex<RelNode>> path = this.findPath(leaf);
            if (!this.matchAndApply(rule, path)) continue;
            return true;
        }
        return false;
    }

    public void optimize() {
        boolean rematch;
        block0: do {
            rematch = false;
            for (Rule rule : rules) {
                if (!this.applyRule(rule)) continue;
                rematch = true;
                this.graph.gc(this.root);
                this.rebuild(this.root);
                continue block0;
            }
        } while (rematch);
    }

    static {
        rules.add(new TableScan2DataSourceRule());
        rules.add(new PredictPushDownRule());
    }
}

