/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.optimize.rbo;

import java.util.ArrayList;
import java.util.List;
import kd.bos.flydb.core.interpreter.bind.BindableDBDataSource;
import kd.bos.flydb.core.interpreter.bind.BindableTableScan;
import kd.bos.flydb.core.optimize.rbo.BaseRule;
import kd.bos.flydb.core.rel.RelNode;
import kd.bos.flydb.core.rex.RexInputRef;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.rex.RexNodeList;
import kd.bos.flydb.core.schema.cosmic.CosmicEntityTable;
import kd.bos.flydb.core.sql.type.DataTypeField;
import kd.bos.flydb.core.util.DirectedGraph;

public class TableScan2DataSourceRule
extends BaseRule {
    public TableScan2DataSourceRule() {
        super(false, new Class[]{BindableTableScan.class});
    }

    @Override
    public boolean isAccept(DirectedGraph.Vertex<RelNode> matchRoot) {
        BindableTableScan tableScan = (BindableTableScan)matchRoot.getNode();
        return tableScan.table instanceof CosmicEntityTable;
    }

    @Override
    public DirectedGraph.Vertex<RelNode> apply(DirectedGraph.Vertex<RelNode> matchRoot, DirectedGraph<RelNode> graph, List<DirectedGraph.Vertex<RelNode>> path) {
        BindableTableScan tableScan = (BindableTableScan)matchRoot.getNode();
        CosmicEntityTable table = (CosmicEntityTable)tableScan.table;
        BindableDBDataSource dataSource = new BindableDBDataSource(table.getDataType());
        dataSource.pushDownFrom(tableScan);
        ArrayList<RexNode> selectList = new ArrayList<RexNode>(tableScan.index.length);
        List<DataTypeField> dataTypeFieldList = table.getDataType().getFieldList();
        for (int i : tableScan.index) {
            selectList.add(new RexInputRef(dataTypeFieldList.get(i).getType(), i));
        }
        dataSource.pushDownSelectList(new RexNodeList(selectList));
        return new DirectedGraph.Vertex<RelNode>(dataSource);
    }
}

