/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.rel;

import kd.bos.flydb.core.rel.AggTranslator;
import kd.bos.flydb.core.rel.RelNode;
import kd.bos.flydb.core.rel.RelTranslator;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;

public class AggCollector {
    private final SqlNodeList preNodeList = new SqlNodeList(SqlParserPosition.ZERO);
    private final SqlNodeList aggCallList = new SqlNodeList(SqlParserPosition.ZERO);
    private final SqlNodeList groupNodeList = new SqlNodeList(SqlParserPosition.ZERO);
    private final SqlNodeList selectList = new SqlNodeList(SqlParserPosition.ZERO);
    private final SqlNodeList orderByList = new SqlNodeList(SqlParserPosition.ZERO);
    private SqlNode having;
    private SqlNode limit;
    private SqlNode offset;
    private final RelTranslator.Blackboard bb;

    public AggCollector(RelTranslator.Blackboard bb) {
        this.bb = bb;
    }

    public void collectGroupList(SqlNodeList groups) {
        for (SqlNode group : groups) {
            if (this.lookupPreNodeList(group) >= 0) continue;
            this.preNodeList.add(group);
            this.groupNodeList.add(group);
        }
    }

    public void collectSelectList(SqlNodeList selectList) {
        for (SqlNode sqlNode : selectList) {
            this.selectList.add(sqlNode);
            this.collect0(sqlNode);
        }
    }

    public void collectHaving(SqlNode having) {
        if (having == null) {
            return;
        }
        this.having = having;
        this.collect0(having);
    }

    public void collectOrderByList(SqlNode sqlNode) {
        if (sqlNode == null) {
            return;
        }
        SqlNodeList orderByList = sqlNode.cast(SqlNodeList.class);
        if (orderByList != null && !orderByList.isEmpty()) {
            for (SqlNode item : orderByList) {
                if (this.lookup0(this.orderByList, item) >= 0) continue;
                this.orderByList.add(item);
                this.collect0(item);
            }
        }
    }

    public void collectLimitOffset(SqlNode limit, SqlNode offset) {
        this.limit = limit;
        this.offset = offset;
    }

    private void collect0(SqlNode sqlNode) {
        block7: {
            block6: {
                if (this.lookupPreNodeList(sqlNode) >= 0) {
                    return;
                }
                if (sqlNode.getKind() == SqlKind.AS) {
                    this.collect0(sqlNode.cast(SqlBasicCall.class).getOperand(0));
                }
                if (!(sqlNode instanceof SqlCall)) break block6;
                if (sqlNode.getKind().isBelong(SqlKind.AGGREGATE_FUNCTIONS) && this.lookup0(this.aggCallList, sqlNode) < 0) {
                    this.aggCallList.add(sqlNode);
                    SqlCall call = sqlNode.cast(SqlCall.class);
                    SqlNode operand = call.getOperand(0);
                    if (operand != null && this.lookupPreNodeList(operand) < 0) {
                        this.preNodeList.add(operand);
                    }
                }
                for (SqlNode node : ((SqlCall)sqlNode).getOperandList()) {
                    this.collect0(node);
                }
                break block7;
            }
            if (!(sqlNode instanceof SqlNodeList)) break block7;
            SqlNodeList list = sqlNode.cast(SqlNodeList.class);
            for (SqlNode node : list) {
                this.collect0(node);
            }
        }
    }

    public int lookupPreNodeList(SqlNode sqlNode) {
        return this.lookup0(this.preNodeList, sqlNode);
    }

    public int lookup0(SqlNodeList list, SqlNode node) {
        if (list == null || list.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equalsOnExpression(node)) continue;
            return i;
        }
        return -1;
    }

    public AggTranslator createAggTranslator(RelNode input) {
        return new AggTranslator(this.bb, this, input);
    }

    public SqlNodeList getPreNodeList() {
        return this.preNodeList;
    }

    public SqlNodeList getAggCallList() {
        return this.aggCallList;
    }

    public SqlNodeList getGroupNodeList() {
        return this.groupNodeList;
    }

    public SqlNodeList getSelectList() {
        return this.selectList;
    }

    public SqlNodeList getOrderByList() {
        return this.orderByList;
    }

    public SqlNode getHaving() {
        return this.having;
    }

    public SqlNode getLimit() {
        return this.limit;
    }

    public SqlNode getOffset() {
        return this.offset;
    }
}

