/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.rel;

import java.util.ArrayList;
import java.util.List;
import kd.bos.flydb.core.rel.AggCollector;
import kd.bos.flydb.core.rel.Aggregate;
import kd.bos.flydb.core.rel.Filter;
import kd.bos.flydb.core.rel.Project;
import kd.bos.flydb.core.rel.RelNode;
import kd.bos.flydb.core.rel.RelTranslator;
import kd.bos.flydb.core.rel.Sort;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.rex.RexNodeList;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.util.SqlValidateUtil;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.util.Utils;

public class AggTranslator {
    private final RelTranslator.Blackboard bb;
    private final AggCollector aggCollector;
    private final SqlValidator validator;
    private RelNode input;

    public AggTranslator(RelTranslator.Blackboard bb, AggCollector aggCollector, RelNode input) {
        this.bb = bb;
        this.aggCollector = aggCollector;
        this.input = input;
        this.validator = bb.getSqlValidator();
    }

    public RelNode trans() {
        this.createPreProject();
        this.createAggregate();
        this.createProject();
        return this.input;
    }

    private void createPreProject() {
        RexNodeList rexNodeList = new RexNodeList();
        SqlNodeList sqlNodeList = this.aggCollector.getPreNodeList();
        ArrayList<String> fieldNameList = new ArrayList<String>(sqlNodeList.size());
        ArrayList<DataType> fieldTypeList = new ArrayList<DataType>(sqlNodeList.size());
        for (int i = 0; i < sqlNodeList.size(); ++i) {
            SqlNode item = sqlNodeList.get(i);
            fieldNameList.add(SqlValidateUtil.getAlias(item, i));
            fieldTypeList.add(this.validator.getValidateNodeType(item));
            if (item.getKind().isBelong(SqlKind.AGGREGATE_FUNCTIONS)) {
                SqlNode aggOperand = item.cast(SqlBasicCall.class).getOperand(0);
                if (aggOperand == null) continue;
                rexNodeList.add(this.bb.transExpression(aggOperand));
                continue;
            }
            rexNodeList.add(this.bb.transExpression(item));
        }
        SqlValidateUtil.renameDuplicate(fieldNameList);
        this.input = new Project(this.input, rexNodeList, fieldNameList, fieldTypeList, this.bb.getSqlValidator().getTypeFactory());
    }

    private void createAggregate() {
        List<Integer> groupIndexList = Utils.expandNumber2List(this.aggCollector.getGroupNodeList().size());
        List<Aggregate.AggCall> aggCallList = this.getAggCallList();
        ArrayList<SqlNode> nodeList = new ArrayList<SqlNode>(this.aggCollector.getGroupNodeList());
        nodeList.addAll(this.aggCollector.getAggCallList());
        ArrayList<String> fieldNameList = new ArrayList<String>(nodeList.size());
        ArrayList<DataType> fieldTypeList = new ArrayList<DataType>(nodeList.size());
        for (int i = 0; i < nodeList.size(); ++i) {
            SqlNode item = (SqlNode)nodeList.get(i);
            fieldNameList.add(SqlValidateUtil.getAlias(item, i));
            fieldTypeList.add(this.bb.getSqlValidator().getValidateNodeType(item));
        }
        SqlValidateUtil.renameDuplicate(fieldNameList);
        this.input = new Aggregate(this.input, groupIndexList, aggCallList, fieldNameList, fieldTypeList, this.bb.getSqlValidator().getTypeFactory());
    }

    private void createProject() {
        this.bb.setAggCollector(this.aggCollector);
        if (this.aggCollector.getHaving() != null) {
            this.input = new Filter(this.input, this.bb.transExpression(this.aggCollector.getHaving()));
        }
        if (!this.aggCollector.getOrderByList().isEmpty() || this.aggCollector.getLimit() != null || this.aggCollector.getOffset() != null) {
            RexNode limit = this.aggCollector.getLimit() == null ? null : this.bb.transExpression(this.aggCollector.getLimit());
            RexNode offset = this.aggCollector.getOffset() == null ? null : this.bb.transExpression(this.aggCollector.getOffset());
            ArrayList<Sort.SortItem> sortList = this.aggCollector.getOrderByList().isEmpty() ? new ArrayList<Sort.SortItem>() : new ArrayList(this.aggCollector.getOrderByList().size());
            for (SqlNode sqlNode : this.aggCollector.getOrderByList()) {
                if (sqlNode.getKind().isBelong(SqlKind.SORT_ITEM_ENDING)) {
                    Sort.Ordering ordering = sqlNode.getKind() == SqlKind.ASCENDING ? Sort.Ordering.ASC : Sort.Ordering.DESC;
                    sortList.add(new Sort.SortItem(ordering, this.bb.transExpression(sqlNode.cast(SqlCall.class).getOperand(0))));
                    continue;
                }
                sortList.add(new Sort.SortItem(Sort.Ordering.ASC, this.bb.transExpression(sqlNode)));
            }
            this.input = new Sort(this.input, offset, limit, sortList);
        }
        SqlNodeList selectList = this.aggCollector.getSelectList();
        RexNodeList list = new RexNodeList(selectList.size());
        ArrayList<String> fieldNameList = new ArrayList<String>(selectList.size());
        ArrayList<DataType> fieldTypeList = new ArrayList<DataType>(selectList.size());
        for (int i = 0; i < selectList.size(); ++i) {
            SqlNode item = (SqlNode)selectList.get(i);
            list.add(this.bb.transExpression(item));
            fieldNameList.add(SqlValidateUtil.getAlias(item, i));
            fieldTypeList.add(this.validator.getValidateNodeType(item));
        }
        SqlValidateUtil.renameDuplicate(fieldNameList);
        this.input = new Project(this.input, list, fieldNameList, fieldTypeList, this.validator.getTypeFactory());
    }

    private List<Aggregate.AggCall> getAggCallList() {
        SqlNodeList aggCallList = this.aggCollector.getAggCallList();
        ArrayList<Aggregate.AggCall> callList = new ArrayList<Aggregate.AggCall>(aggCallList.size());
        for (SqlNode sqlNode : aggCallList) {
            SqlCall call = sqlNode.cast(SqlCall.class);
            SqlOperator operator = call.getOperator();
            Integer index = this.aggCollector.lookupPreNodeList(call.getOperand(0));
            callList.add(new Aggregate.AggCall(operator, index, false, false, this.bb.getSqlValidator().getValidateNodeType(call)));
        }
        return callList;
    }
}

