/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.rel;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.rel.RelNode;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.sql.tree.SqlJoinType;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;

public class Join
implements RelNode {
    public final SqlJoinType joinType;
    public final RexNode condition;
    protected RelNode left;
    protected RelNode right;
    protected DataType type;

    public Join(RelNode left, RelNode right, SqlJoinType joinType, RexNode condition) {
        this.left = left;
        this.right = right;
        this.joinType = joinType;
        this.condition = condition;
        this.type = DataTypeFactory.instance.buildJoinType(left.getRowType(), right.getRowType());
    }

    @Override
    public DataType getRowType() {
        return this.type;
    }

    @Override
    public List<RelNode> getInputList() {
        return Lists.newArrayList((Object[])new RelNode[]{this.left, this.right});
    }

    @Override
    public RelNode getInput(int i) {
        switch (i) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
    }

    @Override
    public void replaceInput(int i, RelNode input) {
        switch (i) {
            case 0: {
                this.left = input;
                break;
            }
            case 1: {
                this.right = input;
                break;
            }
            default: {
                throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
            }
        }
    }
}

