/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.rel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.rel.AggCollector;
import kd.bos.flydb.core.rel.AggTranslator;
import kd.bos.flydb.core.rel.Filter;
import kd.bos.flydb.core.rel.Join;
import kd.bos.flydb.core.rel.Project;
import kd.bos.flydb.core.rel.RelNode;
import kd.bos.flydb.core.rel.Sort;
import kd.bos.flydb.core.rel.TableScan;
import kd.bos.flydb.core.rel.TableScanTag;
import kd.bos.flydb.core.rel.Union;
import kd.bos.flydb.core.rex.RexCall;
import kd.bos.flydb.core.rex.RexDynamicParam;
import kd.bos.flydb.core.rex.RexInputRef;
import kd.bos.flydb.core.rex.RexLiteral;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.rex.RexNodeList;
import kd.bos.flydb.core.rex.RexSubQuery;
import kd.bos.flydb.core.schema.FormAttribute;
import kd.bos.flydb.core.schema.Scanner;
import kd.bos.flydb.core.schema.Table;
import kd.bos.flydb.core.schema.metadata.ColumnInfo;
import kd.bos.flydb.core.schema.metadata.ShowVariablesTable;
import kd.bos.flydb.core.sql.operator.SqlOperators;
import kd.bos.flydb.core.sql.operator.SqlSetOperator;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlDynamicParam;
import kd.bos.flydb.core.sql.tree.SqlIdentifier;
import kd.bos.flydb.core.sql.tree.SqlJoin;
import kd.bos.flydb.core.sql.tree.SqlJoinType;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlLiteral;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.tree.SqlSelect;
import kd.bos.flydb.core.sql.tree.SqlShow;
import kd.bos.flydb.core.sql.tree.SqlShowVariables;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.type.DataTypeField;
import kd.bos.flydb.core.sql.type.TupleDataType;
import kd.bos.flydb.core.sql.util.Pair;
import kd.bos.flydb.core.sql.util.SqlValidateUtil;
import kd.bos.flydb.core.sql.validate.SqlClause;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;
import kd.bos.flydb.core.sql.validate.impl.TableNamespace;

public class RelTranslator {
    private final Map<RelNode, Integer> leaves = new HashMap<RelNode, Integer>();

    public RelNode transQuery(SqlNode node, SqlValidator validator) {
        if (node.getKind().isBelong(SqlKind.SET_OP)) {
            return this.transSetOp(node, validator);
        }
        SqlValidatorScope scope = validator.getClauseScope(node, SqlClause.WHERE);
        Blackboard bb = new Blackboard(validator, scope);
        this.trans(node, validator, bb);
        return bb.root;
    }

    private RelNode transSetOp(SqlNode node, SqlValidator validator) {
        SqlBasicCall call = node.cast(SqlBasicCall.class);
        RelNode left = this.transQuery(call.getOperand(0), validator);
        RelNode right = this.transQuery(call.getOperand(1), validator);
        return new Union(Lists.newArrayList((Object[])new RelNode[]{left, right}), left.getRowType(), ((SqlSetOperator)call.getOperator()).isAll());
    }

    public RelNode transShowStatement(SqlNode node, SqlValidator validator) {
        SqlShow show = node.cast(SqlShow.class);
        SqlValidatorScope scope = validator.getClauseScope(show, SqlClause.WHERE);
        Blackboard bb = new Blackboard(validator, scope);
        TableNamespace tableNamespace = (TableNamespace)validator.getNamespace(show);
        TableScan tableScan = new TableScan(tableNamespace.getTable());
        bb.setRoot(tableScan, true);
        this.transWhere(show.getOperand(1), validator, bb);
        return bb.root;
    }

    public RelNode transUse(SqlNode node, SqlValidator validator) {
        Blackboard bb = new Blackboard(validator, null);
        TableScan tableScan = new TableScan(new Table(){

            @Override
            public List<String> getName() {
                return Lists.newArrayList((Object[])new String[]{"executeResult"});
            }

            @Override
            public List<String> fullyQualityName() {
                return Lists.newArrayList((Object[])new String[]{"executeResult"});
            }

            @Override
            public DataType getDataType() {
                ArrayList fieldNameList = Lists.newArrayList((Object[])new String[]{"code"});
                ArrayList dataTypeList = Lists.newArrayList((Object[])new DataType[]{DataTypeFactory.instance.buildString()});
                return new TupleDataType("executeResult", fieldNameList, dataTypeList);
            }

            @Override
            public DataType getObjectRelationDataType() {
                return null;
            }

            @Override
            public Scanner createScanner(int[] project, RexNode filter) {
                return new Scanner(){

                    @Override
                    public Iterable<Object[]> scan() {
                        ArrayList<Object[]> result = new ArrayList<Object[]>();
                        result.add(new Object[]{"success"});
                        return result;
                    }

                    @Override
                    public DataType getRowType() {
                        return this.getDataType();
                    }

                    @Override
                    public void close() {
                    }
                };
            }

            @Override
            public List<ColumnInfo> getColumnInfos() {
                return null;
            }

            @Override
            public FormAttribute getFormAttribute() {
                return FormAttribute.dummyFormAttribute();
            }

            @Override
            public boolean isAllowTableScanTag(TableScanTag tableScanTag) {
                return false;
            }

            @Override
            public void validate() {
            }
        });
        bb.setRoot(tableScan, true);
        return bb.root;
    }

    public RelNode transShowVariablesStatement(SqlNode node, SqlValidator validator) {
        SqlShowVariables showVariables = node.cast(SqlShowVariables.class);
        DataTypeFactory dataTypeFactory = DataTypeFactory.instance;
        ShowVariablesTable table = new ShowVariablesTable(showVariables.isGlobal());
        RelNode root = new TableScan(table);
        if (showVariables.getPattern() != null) {
            RexInputRef left = new RexInputRef(dataTypeFactory.buildString(), 0);
            SqlLiteral literal = showVariables.getPattern().cast(SqlLiteral.class);
            RexLiteral right = new RexLiteral(literal.getDataType(), literal.getValue());
            RexCall condition = new RexCall(SqlOperators.of(SqlKind.LIKE), Lists.newArrayList((Object[])new RexNode[]{left, right}), dataTypeFactory.buildBoolean());
            root = new Filter(root, condition);
        }
        RexNodeList select = new RexNodeList();
        select.add(new RexInputRef(dataTypeFactory.buildString(), 0));
        select.add(new RexInputRef(dataTypeFactory.buildString(), 1));
        select.add(new RexInputRef(dataTypeFactory.buildString(), 2));
        return new Project(root, select, table.getDataType());
    }

    private void trans(SqlNode node, SqlValidator validator, Blackboard bb) {
        if (node.getKind().isBelong(SqlKind.TOP_LEVEL) && node.getKind() == SqlKind.SELECT) {
            SqlSelect select = node.cast(SqlSelect.class);
            if (select.getOperand(2) == null) {
                this.transOnScalarExpression(select, validator, bb);
                return;
            }
            this.transFrom(select.getOperand(2), validator, bb);
            this.transWhere(select.getOperand(3), validator, bb);
            if (validator.isAgg(select)) {
                this.transGroupBy(select, validator, bb);
            } else {
                this.transOrderBy(select, validator, bb);
                this.transSelectList(select, validator, bb);
            }
        }
    }

    private void transOnScalarExpression(SqlSelect select, SqlValidator validator, Blackboard bb) {
        SqlNodeList selectList = select.getOperand(1).cast(SqlNodeList.class);
        RexNodeList list = new RexNodeList(selectList.size());
        ArrayList<String> fieldNameList = new ArrayList<String>(selectList.size());
        ArrayList<DataType> fieldTypeList = new ArrayList<DataType>(selectList.size());
        for (int i = 0; i < selectList.size(); ++i) {
            SqlNode item = selectList.get(i);
            list.add(bb.transExpression(item));
            fieldNameList.add(SqlValidateUtil.getAlias(item, i));
            fieldTypeList.add(validator.getValidateNodeType(item));
        }
        bb.setRoot(new Project(null, list, fieldNameList, fieldTypeList, validator.getTypeFactory()), true);
    }

    private void transSelectList(SqlSelect select, SqlValidator validator, Blackboard bb) {
        SqlNodeList selectList = select.getOperand(1).cast(SqlNodeList.class);
        RexNodeList list = new RexNodeList(selectList.size());
        ArrayList<String> fieldNameList = new ArrayList<String>(selectList.size());
        ArrayList<DataType> fieldTypeList = new ArrayList<DataType>(selectList.size());
        for (int i = 0; i < selectList.size(); ++i) {
            SqlNode item = selectList.get(i);
            list.add(bb.transExpression(item));
            fieldNameList.add(SqlValidateUtil.getAlias(item, i));
            fieldTypeList.add(validator.getValidateNodeType(item));
        }
        SqlValidateUtil.renameDuplicate(fieldNameList);
        bb.setRoot(new Project(bb.root, list, fieldNameList, fieldTypeList, validator.getTypeFactory()), true);
    }

    private void transOrderBy(SqlSelect select, SqlValidator validator, Blackboard bb) {
        SqlNode orderBy = select.getOperand(7);
        SqlNode limit = select.getOperand(9);
        SqlNode offset = select.getOperand(8);
        if (orderBy == null && limit == null && offset == null) {
            return;
        }
        RexNode limitRexNode = limit == null ? null : bb.transExpression(limit);
        RexNode offsetRexNode = offset == null ? null : bb.transExpression(offset);
        ArrayList<Sort.SortItem> sortList = new ArrayList<Sort.SortItem>(10);
        if (orderBy != null) {
            SqlNodeList orderByList = orderBy.cast(SqlNodeList.class);
            for (SqlNode item : orderByList) {
                if (item.getKind().isBelong(SqlKind.SORT_ITEM_ENDING)) {
                    Sort.Ordering ordering = item.getKind() == SqlKind.ASCENDING ? Sort.Ordering.ASC : Sort.Ordering.DESC;
                    sortList.add(new Sort.SortItem(ordering, bb.transExpression(item.cast(SqlCall.class).getOperand(0))));
                    continue;
                }
                sortList.add(new Sort.SortItem(Sort.Ordering.ASC, bb.transExpression(item)));
            }
        }
        bb.setRoot(new Sort(bb.root, offsetRexNode, limitRexNode, sortList), false);
    }

    private void transGroupBy(SqlSelect select, SqlValidator validator, Blackboard bb) {
        AggCollector aggCollector = new AggCollector(bb);
        if (select.getOperand(4) != null) {
            aggCollector.collectGroupList(select.getOperand(4).cast(SqlNodeList.class));
        }
        aggCollector.collectHaving(select.getOperand(5));
        aggCollector.collectOrderByList(select.getOperand(7));
        aggCollector.collectLimitOffset(select.getOperand(9), select.getOperand(8));
        aggCollector.collectSelectList(select.getOperand(1).cast(SqlNodeList.class));
        AggTranslator aggTranslator = aggCollector.createAggTranslator(bb.root);
        bb.setRoot(aggTranslator.trans(), true);
    }

    private void transWhere(SqlNode sqlCondition, SqlValidator validator, Blackboard bb) {
        if (sqlCondition != null) {
            RexNode condition = bb.transExpression(sqlCondition);
            Filter filter = new Filter(bb.root, condition);
            bb.setRoot(filter, false);
        }
    }

    private void transFrom(SqlNode from, SqlValidator validator, Blackboard bb) {
        if (from.getKind() == SqlKind.AS) {
            SqlBasicCall call = from.cast(SqlBasicCall.class);
            this.transFrom(call.getOperand(0), validator, bb);
        } else if (from.getKind() == SqlKind.IDENTIFIER) {
            TableNamespace namespace = (TableNamespace)validator.getNamespace(from);
            TableScan tableScan = new TableScan(namespace.getTable());
            bb.setRoot(tableScan, true);
        } else if (from.getKind() == SqlKind.JOIN) {
            SqlJoin sqlJoin = from.cast(SqlJoin.class);
            this.transFrom(sqlJoin.getOperand(0), validator, bb);
            RelNode left = bb.root;
            this.transFrom(sqlJoin.getOperand(3), validator, bb);
            RelNode right = bb.root;
            Blackboard fromBlackboard = new Blackboard(validator, validator.getScope(sqlJoin));
            fromBlackboard.setInputs(Lists.newArrayList((Object[])new RelNode[]{left, right}));
            SqlNode condition = sqlJoin.getOperand(4);
            RexNode rexCondition = fromBlackboard.transExpression(condition);
            SqlLiteral sqlJoinTypeLiteral = sqlJoin.getOperand(1).cast(SqlLiteral.class);
            SqlJoinType sqlJoinType = SqlJoinType.valueOf((String)sqlJoinTypeLiteral.getValue());
            Join join = new Join(left, right, sqlJoinType, rexCondition);
            bb.setRoot(join, false);
        } else if (from.getKind().isBelong(SqlKind.TOP_LEVEL)) {
            RelNode subQuery = this.transQuery(from, validator);
            bb.setRoot(subQuery, true);
        }
    }

    public static class LookupContext {
        private final List<Pair<RelNode, Integer>> relOffsetList = new ArrayList<Pair<RelNode, Integer>>();

        public LookupContext(List<RelNode> inputs, RelTranslator translator) {
            AtomicInteger offset = new AtomicInteger(0);
            for (RelNode input : inputs) {
                this.buildOffset(input, translator, offset);
            }
        }

        private void buildOffset(RelNode input, RelTranslator translator, AtomicInteger offset) {
            if (translator.leaves.containsKey(input)) {
                this.relOffsetList.add(new Pair<RelNode, Integer>(input, offset.get()));
                offset.addAndGet((Integer)translator.leaves.get(input));
            } else {
                for (RelNode relNode : input.getInputList()) {
                    this.buildOffset(relNode, translator, offset);
                }
            }
        }

        public Pair<RelNode, Integer> findRel(int index) {
            return this.relOffsetList.get(index);
        }
    }

    public class Blackboard {
        private final SqlValidator sqlValidator;
        private final SqlValidatorScope scope;
        private RelNode root;
        private List<RelNode> inputs;
        private AggCollector aggCollector;

        public Blackboard(SqlValidator sqlValidator, SqlValidatorScope scope) {
            this.sqlValidator = sqlValidator;
            this.scope = scope;
        }

        public void setRoot(RelNode root, boolean isLeaf) {
            this.root = root;
            if (isLeaf) {
                RelTranslator.this.leaves.put(root, root.getRowType().getFieldCount());
            }
            this.inputs = Lists.newArrayList((Object[])new RelNode[]{root});
        }

        public void setInputs(List<RelNode> inputs) {
            this.inputs = inputs;
        }

        public RexNode transExpression(SqlNode sqlNode) {
            if (this.aggCollector != null) {
                int index = this.aggCollector.lookup0(this.aggCollector.getGroupNodeList(), sqlNode);
                if (index >= 0) {
                    return new RexInputRef(this.sqlValidator.getValidateNodeType(sqlNode), index);
                }
                index = this.aggCollector.lookup0(this.aggCollector.getAggCallList(), sqlNode);
                if (index >= 0) {
                    return new RexInputRef(this.sqlValidator.getValidateNodeType(sqlNode), this.aggCollector.getGroupNodeList().size() + index);
                }
            }
            if (sqlNode instanceof SqlBasicCall) {
                SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
                if (call.getKind() == SqlKind.AS) {
                    return this.transExpression(call.getOperand(0));
                }
                List<SqlNode> sqlList = call.getOperandList();
                ArrayList<RexNode> rexList = new ArrayList<RexNode>(sqlList.size());
                for (SqlNode node : sqlList) {
                    rexList.add(this.transExpression(node));
                }
                return new RexCall(call.getOperator(), rexList, this.sqlValidator.getValidateNodeType(call));
            }
            if (sqlNode.getKind() == SqlKind.DYNAMIC_PARAM) {
                SqlDynamicParam dynamicParam = sqlNode.cast(SqlDynamicParam.class);
                return new RexDynamicParam(this.sqlValidator.getValidateNodeType(dynamicParam), dynamicParam.getIndex());
            }
            if (sqlNode.getKind() == SqlKind.IDENTIFIER) {
                SqlIdentifier identifier = sqlNode.cast(SqlIdentifier.class);
                List<SqlValidatorScope.LookupPath> lookupPaths = this.scope.lookupScopeChild(identifier);
                if (lookupPaths.size() != 1) {
                    throw Exceptions.of((ErrorCode)ErrorCode.Unexpected1, (Object[])new Object[]{identifier.toString()});
                }
                SqlValidatorScope.LookupPath path = lookupPaths.get(0);
                if (path.path.size() != 2) {
                    throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedFeature, (SqlParserPosition)identifier.getPosition(), (Object[])new Object[]{identifier.toString()});
                }
                LookupContext lookupContext = new LookupContext(this.inputs, RelTranslator.this);
                Pair<RelNode, Integer> relNodeOffset = lookupContext.findRel(path.child.getOrdinal());
                DataTypeField field = path.child.getNs().getDataType().getField(identifier.getLast());
                return new RexInputRef(this.sqlValidator.getValidateNodeType(identifier), relNodeOffset.getValue() + field.getIndex());
            }
            if (sqlNode.getKind() == SqlKind.LITERAL) {
                SqlLiteral literal = sqlNode.cast(SqlLiteral.class);
                return new RexLiteral(literal.getDataType(), literal.getValue());
            }
            if (sqlNode instanceof SqlCall && sqlNode.isBelong(SqlKind.TOP_LEVEL)) {
                RelTranslator translator = new RelTranslator();
                return new RexSubQuery(((SqlCall)sqlNode).getOperator(), translator.transQuery(sqlNode, this.sqlValidator), this.sqlValidator.getValidateNodeType(sqlNode));
            }
            if (sqlNode instanceof SqlNodeList) {
                SqlNodeList sqlList = sqlNode.cast(SqlNodeList.class);
                ArrayList<RexNode> nodeList = new ArrayList<RexNode>(sqlList.size());
                for (SqlNode node : sqlList) {
                    nodeList.add(this.transExpression(node));
                }
                return new RexNodeList(nodeList);
            }
            throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedFeature, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{sqlNode.toSql()});
        }

        public void setAggCollector(AggCollector aggCollector) {
            this.aggCollector = aggCollector;
        }

        public SqlValidator getSqlValidator() {
            return this.sqlValidator;
        }
    }
}

