/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.rel;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.rel.RelTranslator;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNumericLiteral;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.TypeCoercion;
import kd.bos.flydb.core.sql.util.Pair;

final class RelUtil {
    private static final TypeCoercion typeCoercion = new TypeCoercion();
    private static final Calc<Integer> arithmeticBinaryCalcOfInt = (sqlKind, left, right) -> {
        if (sqlKind == SqlKind.PLUS) {
            return left + right;
        }
        if (sqlKind == SqlKind.MINUS) {
            return left - right;
        }
        if (sqlKind == SqlKind.TIMES) {
            return left * right;
        }
        if (sqlKind == SqlKind.DIVIDE) {
            return left / right;
        }
        if (sqlKind == SqlKind.MOD) {
            return left % right;
        }
        throw Exceptions.optimize.unexpected(String.format("Unexpected sql kind of %s here.", new Object[]{sqlKind}));
    };
    private static final Calc<Long> arithmeticBinaryCalcOfLong = (sqlKind, left, right) -> {
        if (sqlKind == SqlKind.PLUS) {
            return left + right;
        }
        if (sqlKind == SqlKind.MINUS) {
            return left - right;
        }
        if (sqlKind == SqlKind.TIMES) {
            return left * right;
        }
        if (sqlKind == SqlKind.DIVIDE) {
            return left / right;
        }
        if (sqlKind == SqlKind.MOD) {
            return left % right;
        }
        throw Exceptions.optimize.unexpected(String.format("Unexpected sql kind of %s here.", new Object[]{sqlKind}));
    };
    private static final Calc<BigDecimal> arithmeticBinaryCalcOfDecimal = (sqlKind, left, right) -> {
        if (sqlKind == SqlKind.PLUS) {
            return left.add((BigDecimal)right);
        }
        if (sqlKind == SqlKind.MINUS) {
            return left.subtract((BigDecimal)right);
        }
        if (sqlKind == SqlKind.TIMES) {
            return left.multiply((BigDecimal)right);
        }
        if (sqlKind == SqlKind.DIVIDE) {
            return left.divide((BigDecimal)right);
        }
        if (sqlKind == SqlKind.MOD) {
            return left.divideAndRemainder((BigDecimal)right)[1];
        }
        throw Exceptions.optimize.unexpected(String.format("Unexpected sql kind of %s here.", new Object[]{sqlKind}));
    };

    private RelUtil() {
    }

    public static Pair<Boolean, List<RexNode>> optimizeArithmeticBinaryExpression(SqlBasicCall call, RelTranslator.Blackboard blackboard) {
        List<SqlNode> sqlList = call.getOperandList();
        ArrayList<RexNode> rexList = new ArrayList<RexNode>(sqlList.size());
        SqlKind kind = call.getKind();
        if (kind.isBelong(SqlKind.ARITHMETICS)) {
            SqlNode left = call.getOperand(0);
            SqlNode right = call.getOperand(1);
            if (left instanceof SqlNumericLiteral && right instanceof SqlNumericLiteral) {
                SqlNumericLiteral leftNumLiteral = left.cast(SqlNumericLiteral.class);
                SqlNumericLiteral rightNumLiteral = right.cast(SqlNumericLiteral.class);
                DataType leftNumDataType = leftNumLiteral.getDataType();
                DataType rightNumDataType = rightNumLiteral.getDataType();
                Number leftValue = (Number)leftNumLiteral.getValue();
                Number rightValue = (Number)rightNumLiteral.getValue();
                DataType dataType = typeCoercion.higherPrecision4NumberType(leftNumDataType, rightNumDataType);
                if (dataType == null) {
                    throw Exceptions.optimize.unexpected(String.format("Unexpected dataType{left=%s,right=%s} while inferring to higher numeric type of both sqlNumericLiteral.", leftNumDataType.id(), rightNumDataType.id()));
                }
                switch (dataType.getTypeName()) {
                    case INT: {
                        Integer intCalc = arithmeticBinaryCalcOfInt.calc(kind, leftValue.intValue(), rightValue.intValue());
                        rexList.add(blackboard.transExpression(new SqlNumericLiteral(call.getPosition(), intCalc)));
                        break;
                    }
                    case LONG: {
                        Long longCalc = arithmeticBinaryCalcOfLong.calc(kind, leftValue.longValue(), rightValue.longValue());
                        rexList.add(blackboard.transExpression(new SqlNumericLiteral(call.getPosition(), longCalc)));
                        break;
                    }
                    case DECIMAL: {
                        BigDecimal decimalCalc = arithmeticBinaryCalcOfDecimal.calc(kind, BigDecimal.valueOf(leftValue.doubleValue()), BigDecimal.valueOf(rightValue.doubleValue()));
                        rexList.add(blackboard.transExpression(new SqlNumericLiteral(call.getPosition(), decimalCalc)));
                        break;
                    }
                    default: {
                        throw Exceptions.optimize.unexpected(String.format("Unexpected dataTypeName=%s.", dataType.getTypeName()));
                    }
                }
                return new Pair<Boolean, List<RexNode>>(true, rexList);
            }
        }
        for (SqlNode node : sqlList) {
            rexList.add(blackboard.transExpression(node));
        }
        return new Pair<Boolean, List<RexNode>>(false, rexList);
    }

    static interface Calc<T> {
        public T calc(SqlKind var1, T var2, T var3);
    }
}

