/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.rel;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.rel.RelNode;
import kd.bos.flydb.core.sql.type.DataType;

public abstract class SingleRel
implements RelNode {
    protected RelNode input;
    protected DataType type;

    public SingleRel(RelNode input) {
        this.input = input;
    }

    public SingleRel(RelNode input, DataType type) {
        this.input = input;
        this.type = type;
    }

    @Override
    public RelNode getInput(int i) {
        if (i != 0) {
            throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
        }
        return this.input;
    }

    @Override
    public List<RelNode> getInputList() {
        if (this.input == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])new RelNode[]{this.input});
    }

    @Override
    public DataType getRowType() {
        return this.type;
    }

    @Override
    public void replaceInput(int i, RelNode input) {
        if (i != 0) {
            throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
        }
        this.input = input;
    }
}

