/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.rex;

import java.util.ArrayList;
import java.util.List;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.rex.RexNodeVisitor;
import kd.bos.flydb.core.rex.RexNodeVisitor1;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.type.DataType;

public class RexCall
implements RexNode {
    private SqlOperator operator;
    private List<RexNode> operands;
    private DataType type;
    private String digest;

    public RexCall(SqlOperator operator, List<RexNode> operands, DataType type) {
        this.operator = operator;
        this.operands = new ArrayList<RexNode>(operands);
        this.type = type;
        this.buildDigest();
    }

    @Override
    public <T> T accept(RexNodeVisitor<T> visitor) {
        return visitor.visitRexCall(this);
    }

    @Override
    public void accept(RexNodeVisitor1 visitor1) {
        visitor1.visitRexCall(this);
    }

    @Override
    public List<RexNode> getChildren() {
        return new ArrayList<RexNode>(this.operands);
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public SqlKind getKind() {
        return this.operator.getKind();
    }

    @Override
    public String getDigest() {
        return this.digest;
    }

    public final void buildDigest() {
        if (this.operator.getKind().isBelong(SqlKind.FUNCTIONS)) {
            ArrayList<String> operandsDigest = new ArrayList<String>(this.operands.size());
            for (RexNode operand : this.operands) {
                if (operand == null) {
                    operandsDigest.add("NULL");
                    continue;
                }
                operandsDigest.add(operand.getDigest());
            }
            this.digest = String.format("%s(%s)", this.operator.name(), String.join((CharSequence)",", operandsDigest));
        } else if (this.operator.getKind().isBelong(SqlKind.LOGIC_OP_KINDS) || this.operator.getKind().isBelong(SqlKind.ARITHMETICS) || this.operator.getKind().isBelong(SqlKind.COMPARISON_KINDS) || this.operator.getKind().isBelong(SqlKind.IN_KINDS) || this.operator.getKind().isBelong(SqlKind.LIKE_KINDS)) {
            this.digest = this.operator.getKind() == SqlKind.NOT ? String.format("(%s %s)", this.operator.name(), this.operands.get(0).getDigest()) : String.format("(%s %s %s)", this.operands.get(0).getDigest(), this.operator.name(), this.operands.get(1).getDigest());
        } else {
            ArrayList<String> operandsDigest = new ArrayList<String>(this.operands.size());
            for (RexNode operand : this.operands) {
                if (operand == null) {
                    operandsDigest.add("NULL");
                    continue;
                }
                operandsDigest.add(operand.getDigest());
            }
            this.digest = String.format("(%s %s)", this.operator.name(), String.join((CharSequence)",", operandsDigest));
        }
    }

    @Override
    public boolean deepEquals(RexNode other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof RexCall)) {
            return false;
        }
        RexCall o = other.cast(RexCall.class);
        if (!this.type.equals(o.type)) {
            return false;
        }
        if (this.operator.getKind() != o.operator.getKind()) {
            return false;
        }
        if (this.operands == null && o.operands == null) {
            return true;
        }
        if (this.operands == null || o.operands == null) {
            return false;
        }
        if (this.operands.size() != o.operands.size()) {
            return false;
        }
        for (int i = 0; i < this.operands.size(); ++i) {
            if (this.operands.get(i).deepEquals(o.operands.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isConstExpression() {
        if (!this.operands.isEmpty()) {
            boolean isConstExp = true;
            for (RexNode rexNode : this.operands) {
                if (!(isConstExp &= rexNode.isConstExpression())) break;
            }
            return isConstExp;
        }
        return false;
    }

    public SqlOperator getOperator() {
        return this.operator;
    }

    public List<RexNode> getOperands() {
        return this.operands;
    }

    public RexNode getOperand(int i) {
        return this.operands.get(i);
    }

    public void replaceOperand(int i, RexNode operand) {
        this.operands.set(i, operand);
    }
}

