/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.rex;

import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.rex.RexNodeVisitor;
import kd.bos.flydb.core.rex.RexNodeVisitor1;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.type.DataType;

public class RexDynamicParam
implements RexNode {
    private final DataType dataType;
    private final int index;

    public RexDynamicParam(DataType dataType, int index) {
        this.dataType = dataType;
        this.index = index;
    }

    @Override
    public <T> T accept(RexNodeVisitor<T> visitor) {
        return visitor.visitRexDynamicParam(this);
    }

    @Override
    public void accept(RexNodeVisitor1 visitor1) {
        visitor1.visitRexDynamicParam(this);
    }

    @Override
    public DataType getType() {
        return this.dataType;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.DYNAMIC_PARAM;
    }

    @Override
    public String getDigest() {
        return ":" + this.index;
    }

    @Override
    public boolean deepEquals(RexNode other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof RexDynamicParam)) {
            return false;
        }
        RexDynamicParam o = other.cast(RexDynamicParam.class);
        return this.index == o.index && this.dataType.equals(o.dataType);
    }

    public int getIndex() {
        return this.index;
    }
}

