/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.rex;

import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.rex.RexNodeVisitor;
import kd.bos.flydb.core.rex.RexNodeVisitor1;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.type.DataType;

public class RexInputRef
implements RexNode {
    private final DataType dataType;
    private final int index;

    public RexInputRef(DataType dataType, int index) {
        this.dataType = dataType;
        this.index = index;
    }

    @Override
    public <T> T accept(RexNodeVisitor<T> visitor) {
        return visitor.visitRexInputRef(this);
    }

    @Override
    public void accept(RexNodeVisitor1 visitor1) {
        visitor1.visitRexInputRef(this);
    }

    @Override
    public DataType getType() {
        return this.dataType;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.INPUT_REF;
    }

    @Override
    public String getDigest() {
        return "$" + this.index;
    }

    public String toString() {
        return this.getDigest();
    }

    @Override
    public boolean deepEquals(RexNode other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof RexInputRef)) {
            return false;
        }
        RexInputRef o = other.cast(RexInputRef.class);
        return this.index == o.index && this.dataType.equals(o.dataType);
    }

    public int getIndex() {
        return this.index;
    }
}

