/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.rex;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.rex.RexNodeVisitor;
import kd.bos.flydb.core.rex.RexNodeVisitor1;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.NullDataType;
import kd.bos.flydb.core.sql.type.SqlTypeName;
import kd.bos.flydb.core.sql.util.KSqlTimeLiteralHandler;

public class RexLiteral
implements RexNode {
    private DataType type;
    private Object value;
    private String digest;

    public RexLiteral(DataType type, Object value) {
        this.type = type;
        this.value = value;
        this.buildDigest();
    }

    @Override
    public <T> T accept(RexNodeVisitor<T> visitor) {
        return visitor.visitRexLiteral(this);
    }

    @Override
    public void accept(RexNodeVisitor1 visitor1) {
        visitor1.visitRexLiteral(this);
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.LITERAL;
    }

    @Override
    public String getDigest() {
        return this.digest;
    }

    private void buildDigest() {
        if (this.value == null) {
            this.digest = "NULL";
            return;
        }
        SqlTypeName typeName = this.type.getTypeName();
        switch (typeName) {
            case INT: 
            case BOOLEAN: 
            case STRING: {
                this.digest = String.valueOf(this.value);
                break;
            }
            case LONG: {
                this.digest = String.valueOf(this.value) + 'L';
                break;
            }
            case DECIMAL: {
                this.digest = this.value.toString();
                break;
            }
            case TIME: {
                if (this.value instanceof Time) {
                    this.digest = String.format("TIME '%s'", new SimpleDateFormat("HH:mm:ss").format(this.value));
                    break;
                }
                if (this.value instanceof LocalTime) {
                    this.digest = String.format("TIME '%s'", KSqlTimeLiteralHandler.tDtf.format((LocalTime)this.value));
                    this.value = Time.valueOf((LocalTime)this.value);
                    break;
                }
                if (this.value instanceof Date) {
                    this.digest = String.format("TIME '%s'", new SimpleDateFormat("HH:mm:ss").format((Date)this.value));
                    this.value = Time.valueOf(new SimpleDateFormat("HH:mm:ss").format((Date)this.value));
                    break;
                }
                throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
            }
            case DATE: {
                if (this.value instanceof java.sql.Date) {
                    this.digest = String.format("DATE '%s'", new SimpleDateFormat("yyyy-MM-dd").format(this.value));
                    break;
                }
                if (this.value instanceof LocalDate) {
                    this.digest = String.format("DATE '%s'", KSqlTimeLiteralHandler.dDtf.format((TemporalAccessor)this.value));
                    this.value = java.sql.Date.valueOf((LocalDate)this.value);
                    break;
                }
                if (this.value instanceof Date) {
                    this.digest = String.format("DATE '%s'", new SimpleDateFormat("yyyy-MM-dd").format(this.value));
                    this.value = java.sql.Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(this.value));
                    break;
                }
                throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
            }
            case DATETIME: {
                if (this.value instanceof Timestamp) {
                    this.digest = String.format("DATETIME '%s'", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.value));
                    break;
                }
                if (this.value instanceof LocalDateTime) {
                    this.digest = String.format("DATETIME '%s'", KSqlTimeLiteralHandler.tsDtf.format((LocalDateTime)this.value));
                    this.value = Timestamp.valueOf((LocalDateTime)this.value);
                    break;
                }
                if (this.value instanceof Date) {
                    this.digest = String.format("DATETIME '%s'", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)this.value));
                    this.value = new Timestamp(((Date)this.value).getTime());
                    break;
                }
                throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
            }
            default: {
                throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
            }
        }
    }

    @Override
    public boolean deepEquals(RexNode other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof RexLiteral)) {
            return false;
        }
        RexLiteral o = other.cast(RexLiteral.class);
        return this.type.equals(o.type) && this.value.equals(o.value);
    }

    @Override
    public boolean isConstExpression() {
        SqlTypeName typeName = this.type.getTypeName();
        switch (typeName) {
            case INT: 
            case LONG: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    public boolean isNullExpression() {
        return this.type instanceof NullDataType && this.value == null;
    }

    public Object getValue() {
        return this.value;
    }
}

